/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.bytes;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.EpsilonTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Groups;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.OrdinaryTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.State;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Transition;
import net.amygdalum.util.worklist.WorkSet;

public class NFAMatcherState {
    private Set<Item> items;

    public NFAMatcherState(Set<Item> items) {
        this.items = items;
    }

    public static NFAMatcherState of(State state, Groups groups, long pos) {
        Set<Item> items = NFAMatcherState.items(state, groups, pos);
        return new NFAMatcherState(items);
    }

    private static Set<Item> items(State state, Groups groups, long pos) {
        WorkSet todo = new WorkSet();
        todo.add((Object)new Item(state, groups));
        while (!todo.isEmpty()) {
            Item item = (Item)todo.remove();
            for (Transition transition : item.state.out()) {
                if (!(transition instanceof EpsilonTransition)) continue;
                EpsilonTransition epsilon = (EpsilonTransition)transition;
                State target = epsilon.getTarget();
                Groups targetGroups = epsilon.executeAction(item.groups, pos);
                todo.add((Object)new Item(target, targetGroups));
            }
        }
        return todo.getDone();
    }

    public NFAMatcherState next(byte b, long pos) {
        HashSet<Item> nextItems = new HashSet<Item>();
        for (Item item : this.items) {
            State state = item.state;
            Groups groups = item.groups;
            for (Transition transition : state.out()) {
                if (!(transition instanceof OrdinaryTransition) || !((OrdinaryTransition)transition).accepts(b)) continue;
                State target = transition.getTarget();
                Groups targetGroups = transition.executeAction(groups, pos);
                nextItems.addAll(NFAMatcherState.items(target, targetGroups, pos));
            }
        }
        return new NFAMatcherState(nextItems);
    }

    public boolean isAccepting(long pos) {
        for (Item item : this.items) {
            State state = item.state;
            if (!state.isAccepting()) continue;
            return true;
        }
        return false;
    }

    public SortedSet<Groups> getGroups() {
        TreeSet<Groups> groups = new TreeSet<Groups>();
        for (Item item : this.items) {
            if (item.groups.invalid()) continue;
            groups.add(item.groups);
        }
        return groups;
    }

    public NFAMatcherState cancelOverlapping(SortedSet<Groups> groups) {
        HashSet<Item> nonOverlappingItems = new HashSet<Item>();
        block0: for (Item item : this.items) {
            Groups itemGroup = item.groups;
            for (Groups group : groups) {
                if (!group.overlaps(itemGroup)) continue;
                continue block0;
            }
            nonOverlappingItems.add(item);
        }
        return new NFAMatcherState(nonOverlappingItems);
    }

    public String toString() {
        return this.items.toString();
    }

    private static class Item {
        public State state;
        public Groups groups;

        public Item(State state, Groups groups) {
            this.state = state;
            this.groups = groups;
        }

        public int hashCode() {
            return this.state.hashCode() + this.groups.hashCode() * 17;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item that = (Item)obj;
            return this.state == that.state && this.groups.equals(that.groups);
        }

        public String toString() {
            return this.state.toString() + ":" + this.groups.toString();
        }
    }
}

