/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.bytes;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.ByteTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.BytesTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.EndGroup;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.EpsilonTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFAComponent;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFAComponentFactory;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.SimpleNFAComponentFactory;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.StartGroup;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.State;
import net.amygdalum.regexparser.AlternativesNode;
import net.amygdalum.regexparser.AnyCharNode;
import net.amygdalum.regexparser.BoundedLoopNode;
import net.amygdalum.regexparser.CharClassNode;
import net.amygdalum.regexparser.CompClassNode;
import net.amygdalum.regexparser.ConcatNode;
import net.amygdalum.regexparser.EmptyNode;
import net.amygdalum.regexparser.GroupNode;
import net.amygdalum.regexparser.OptionalNode;
import net.amygdalum.regexparser.RangeCharNode;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.SingleCharNode;
import net.amygdalum.regexparser.SpecialCharClassNode;
import net.amygdalum.regexparser.StringNode;
import net.amygdalum.regexparser.UnboundedLoopNode;
import net.amygdalum.util.text.ByteEncoding;
import net.amygdalum.util.text.ByteRange;
import net.amygdalum.util.text.ByteUtils;

public class NFABuilder
implements RegexNodeVisitor<NFAComponent> {
    private static final byte MAXBYTE = -1;
    private static final byte MINBYTE = 0;
    private NFAComponentFactory factory;
    private Charset charset;
    private int groupIndex;

    public NFABuilder(Charset charset) {
        this(charset, new SimpleNFAComponentFactory());
    }

    public NFABuilder(Charset charset, NFAComponentFactory factory) {
        this.factory = factory;
        this.charset = charset;
        this.groupIndex = 0;
    }

    private int nextGroupIndex() {
        ++this.groupIndex;
        return this.groupIndex;
    }

    public NFAComponent match(char value) {
        State s = new State();
        State e = new State();
        this.connect(s, e, value);
        return this.factory.create(s, e);
    }

    public NFAComponent match(String value) {
        State s = new State();
        State e = new State();
        this.connect(s, e, value);
        return this.factory.create(s, e);
    }

    public NFAComponent match(char from, char to) {
        State s = new State();
        State e = new State();
        if (from > to) {
            char temp = from;
            from = to;
            to = temp;
        }
        this.connect(s, e, from, to);
        return this.factory.create(s, e);
    }

    private void connect(State s, State e, byte[] bytes) {
        if (bytes.length != 0) {
            if (bytes.length == 1) {
                new ByteTransition(s, bytes[0], e).connect();
            } else {
                int length = bytes.length;
                State[] chain = new State[length - 1];
                for (int i = 0; i < chain.length; ++i) {
                    chain[i] = new State();
                }
                int last = chain.length - 1;
                new ByteTransition(s, bytes[0], chain[0]).connect();
                for (int i = 1; i < length - 1; ++i) {
                    new ByteTransition(chain[i - 1], bytes[i], chain[i]).connect();
                }
                new ByteTransition(chain[last], bytes[bytes.length - 1], e).connect();
            }
        }
    }

    private void connect(State s, State e, ByteRange bytes) {
        int length = bytes.from.length;
        if (length != 0) {
            if (length == 1) {
                new BytesTransition(s, bytes.from[0], bytes.to[0], e).connect();
            } else {
                State[] states = new State[]{s};
                for (int i = 0; i < length - 1; ++i) {
                    states = this.connectState(states, bytes.from[i], bytes.to[i]);
                }
                this.connectState(states, bytes.from[length - 1], bytes.to[length - 1], e);
            }
        }
    }

    private State[] connectState(State[] states, byte from, byte to) {
        if (states.length == 1) {
            if (from == to) {
                State[] next = new State[]{new State()};
                new ByteTransition(states[0], from, next[0]).connect();
                return next;
            }
            if (to - from == 1) {
                State[] next = new State[]{new State(), new State()};
                new ByteTransition(states[0], from, next[0]).connect();
                new ByteTransition(states[0], to, next[1]).connect();
                return next;
            }
            State[] next = new State[]{new State(), new State(), new State()};
            new ByteTransition(states[0], from, next[0]).connect();
            new BytesTransition(states[0], ByteUtils.after((byte)from), ByteUtils.before((byte)to), next[1]).connect();
            new ByteTransition(states[0], to, next[2]).connect();
            return next;
        }
        if (states.length == 2) {
            if (from == -1 && to == 0) {
                State[] next = new State[]{new State(), new State()};
                new ByteTransition(states[0], from, next[0]).connect();
                new ByteTransition(states[1], to, next[1]).connect();
                return next;
            }
            State[] next = new State[]{new State(), new State(), new State()};
            new ByteTransition(states[0], from, next[0]).connect();
            if (from != -1) {
                new BytesTransition(states[0], ByteUtils.after((byte)from), -1, next[1]).connect();
            }
            if (to != 0) {
                new BytesTransition(states[1], 0, ByteUtils.before((byte)to), next[1]).connect();
            }
            new ByteTransition(states[1], to, next[2]).connect();
            return next;
        }
        if (states.length == 3) {
            State[] next = new State[]{new State(), new State(), new State()};
            new ByteTransition(states[0], from, next[0]).connect();
            if (from != -1) {
                new BytesTransition(states[0], ByteUtils.after((byte)from), -1, next[1]).connect();
            }
            new BytesTransition(states[1], 0, -1, next[1]).connect();
            if (to != 0) {
                new BytesTransition(states[2], 0, ByteUtils.before((byte)to), next[1]).connect();
            }
            new ByteTransition(states[2], to, next[2]).connect();
            return next;
        }
        return new State[0];
    }

    private void connectState(State[] states, byte from, byte to, State terminator) {
        if (states.length == 1 && from == to) {
            new ByteTransition(states[0], from, terminator).connect();
        } else if (states.length == 2) {
            if (from == -1 && to == 0) {
                new ByteTransition(states[0], from, terminator).connect();
                new ByteTransition(states[1], to, terminator).connect();
            } else {
                new ByteTransition(states[0], from, terminator).connect();
                if (from != -1) {
                    new BytesTransition(states[0], ByteUtils.after((byte)from), -1, terminator).connect();
                }
                if (to != 0) {
                    new BytesTransition(states[1], 0, ByteUtils.before((byte)to), terminator).connect();
                }
                new ByteTransition(states[1], to, terminator).connect();
            }
        } else if (states.length == 3) {
            new ByteTransition(states[0], from, terminator).connect();
            if (from != -1) {
                new BytesTransition(states[0], ByteUtils.after((byte)from), -1, terminator).connect();
            }
            new BytesTransition(states[1], 0, -1, terminator).connect();
            if (to != 0) {
                new BytesTransition(states[2], 0, ByteUtils.before((byte)to), terminator).connect();
            }
            new ByteTransition(states[2], to, terminator).connect();
        }
    }

    private void connect(State s, State e, String value) {
        this.connect(s, e, ByteEncoding.encode((String)value, (Charset)this.charset));
    }

    private void connect(State s, State e, char value) {
        this.connect(s, e, ByteEncoding.encode((Charset)this.charset, (char)value));
    }

    private void connect(State s, State e, char from, char to) {
        for (ByteRange bytes : ByteEncoding.intervals((Charset)this.charset, (char)from, (char)to)) {
            this.connect(s, e, bytes);
        }
    }

    public NFAComponent matchGroup(NFAComponent a, int no) {
        State s = new State();
        State e = new State();
        new EpsilonTransition(s, a.start).withAction(new StartGroup(no)).connect();
        new EpsilonTransition(a.end, e).withAction(new EndGroup(no)).connect();
        return this.factory.create(s, e);
    }

    public NFAComponent matchAlternatives(List<NFAComponent> as) {
        if (as.size() == 1) {
            return as.get(0);
        }
        State s = new State();
        State e = new State();
        for (NFAComponent a : as) {
            State n = a.start;
            new EpsilonTransition(s, n).connect();
            new EpsilonTransition(a.end, e).connect();
        }
        return this.factory.create(s, e);
    }

    public NFAComponent matchConcatenation(List<NFAComponent> as) {
        if (as.size() == 1) {
            return as.get(0);
        }
        State s = as.get((int)0).start;
        State e = as.get((int)(as.size() - 1)).end;
        State last = null;
        ListIterator<NFAComponent> aIterator = as.listIterator();
        while (aIterator.hasNext()) {
            NFAComponent a = aIterator.next();
            if (last != null) {
                new EpsilonTransition(last, a.start).connect();
            }
            last = a.end;
        }
        return this.factory.create(s, e);
    }

    public NFAComponent matchEmpty() {
        State s = new State();
        return this.factory.create(s, s);
    }

    public NFAComponent matchNothing() {
        State s = new State();
        return this.factory.create(s, null);
    }

    public NFAComponent matchOptional(NFAComponent a) {
        State s = new State();
        State e = new State();
        new EpsilonTransition(s, e).connect();
        new EpsilonTransition(s, a.start).connect();
        new EpsilonTransition(a.end, e).connect();
        return this.factory.create(s, e);
    }

    public NFAComponent matchUnlimitedLoop(NFAComponent a, int start) {
        if (start == 0) {
            return this.matchStarLoop(a);
        }
        ArrayList<NFAComponent> as = new ArrayList<NFAComponent>();
        as.addAll(NFABuilder.copyOf(a.clone(), start));
        as.add(this.matchStarLoop(a));
        return this.matchConcatenation(as);
    }

    public NFAComponent matchStarLoop(NFAComponent a) {
        State s = new State();
        State e = new State();
        new EpsilonTransition(s, a.start).connect();
        new EpsilonTransition(s, e).connect();
        new EpsilonTransition(a.end, a.start).connect();
        new EpsilonTransition(a.end, e).connect();
        return this.factory.create(s, e);
    }

    public NFAComponent matchRangeLoop(NFAComponent a, int start, int end) {
        if (start == end) {
            return this.matchFixedLoop(a, start);
        }
        if (start == 0) {
            return this.matchUpToN(a, end);
        }
        NFAComponent aFixed = this.matchFixedLoop(a.clone(), start);
        NFAComponent aUpToN = this.matchUpToN(a, end - start);
        NFAComponent matchConcatenation = this.matchConcatenation(Arrays.asList(aFixed, aUpToN));
        return matchConcatenation;
    }

    public NFAComponent matchFixedLoop(NFAComponent a, int count) {
        List<NFAComponent> as = NFABuilder.copyOf(a, count);
        return this.matchConcatenation(as);
    }

    public NFAComponent matchUpToN(NFAComponent a, int count) {
        State s = new State();
        State e = new State();
        new EpsilonTransition(s, e).connect();
        State current = s;
        for (int i = 0; i < count; ++i) {
            NFAComponent ai = a.clone();
            new EpsilonTransition(current, ai.start).connect();
            new EpsilonTransition(ai.end, e).connect();
            current = ai.end;
        }
        return this.factory.create(s, e);
    }

    private static List<NFAComponent> copyOf(NFAComponent a, int count) {
        ArrayList<NFAComponent> copies = new ArrayList<NFAComponent>(count);
        copies.add(a);
        for (int i = 1; i < count; ++i) {
            copies.add(a.clone());
        }
        return copies;
    }

    public NFAComponent visitAlternatives(AlternativesNode node) {
        List<NFAComponent> as = this.accept(node.getSubNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitAnyChar(AnyCharNode node) {
        List<NFAComponent> as = this.accept(node.toCharNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitCharClass(CharClassNode node) {
        List<NFAComponent> as = this.accept(node.toCharNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitCompClass(CompClassNode node) {
        List<NFAComponent> as = this.accept(node.toCharNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitConcat(ConcatNode node) {
        List<NFAComponent> as = this.accept(node.getSubNodes());
        return this.matchConcatenation(as);
    }

    public NFAComponent visitEmpty(EmptyNode node) {
        return this.matchEmpty();
    }

    public NFAComponent visitGroup(GroupNode node) {
        int no = this.nextGroupIndex();
        NFAComponent a = (NFAComponent)node.getSubNode().accept((RegexNodeVisitor)this);
        return this.matchGroup(a, no);
    }

    public NFAComponent visitBoundedLoop(BoundedLoopNode node) {
        NFAComponent a = (NFAComponent)node.getSubNode().accept((RegexNodeVisitor)this);
        int from = node.getFrom();
        int to = node.getTo();
        return this.matchRangeLoop(a, from, to);
    }

    public NFAComponent visitUnboundedLoop(UnboundedLoopNode node) {
        NFAComponent a = (NFAComponent)node.getSubNode().accept((RegexNodeVisitor)this);
        int from = node.getFrom();
        return this.matchUnlimitedLoop(a, from);
    }

    public NFAComponent visitOptional(OptionalNode node) {
        NFAComponent a = (NFAComponent)node.getSubNode().accept((RegexNodeVisitor)this);
        return this.matchOptional(a);
    }

    public NFAComponent visitRangeChar(RangeCharNode node) {
        return this.match(node.getFrom(), node.getTo());
    }

    public NFAComponent visitSingleChar(SingleCharNode node) {
        return this.match(node.getValue());
    }

    public NFAComponent visitSpecialCharClass(SpecialCharClassNode node) {
        List<NFAComponent> as = this.accept(node.toCharNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitString(StringNode node) {
        return this.match(node.getValue());
    }

    private List<NFAComponent> accept(List<? extends RegexNode> nodes) {
        ArrayList<NFAComponent> as = new ArrayList<NFAComponent>(nodes.size());
        for (RegexNode regexNode : nodes) {
            as.add((NFAComponent)regexNode.accept((RegexNodeVisitor)this));
        }
        return as;
    }

    public NFA build(RegexNode node) {
        NFAComponent nfa = (NFAComponent)node.accept((RegexNodeVisitor)this);
        return this.build(nfa);
    }

    public NFA build(NFAComponent nfa) {
        State start = nfa.start;
        State end = nfa.end;
        if (end != null) {
            end.setAccepting();
        }
        return new NFA(start, this.charset);
    }
}

