/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.bytes;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Action;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.ByteTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.BytesTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.EpsilonTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.OrdinaryTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.State;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.StateClone;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Transition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.TransitionComparator;
import net.amygdalum.util.builders.Lists;
import net.amygdalum.util.text.ByteRange;
import net.amygdalum.util.worklist.WorkSet;

public class NFA
implements Cloneable {
    private Charset charset;
    private State start;
    private List<ByteRange> byteRanges;
    private State[] states;
    private int accepting;

    public NFA(State start, Charset charset) {
        this.charset = charset;
        this.init(start);
    }

    private void init(State start) {
        this.start = start;
        this.byteRanges = NFA.computeEquivalentByteRanges(start);
        this.states = NFA.clean(start, null);
        this.accepting = NFA.order(this.states);
    }

    private void init(State start, State error) {
        this.start = start;
        this.byteRanges = NFA.computeEquivalentByteRanges(start);
        this.states = NFA.clean(start, error);
        this.accepting = NFA.order(this.states);
    }

    public State getStart() {
        return this.start;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public State[] states() {
        return this.states;
    }

    public State[] accepting() {
        return Arrays.copyOfRange(this.states, this.accepting, this.states.length);
    }

    private static State[] clean(State start, State error) {
        WorkSet todo = new WorkSet();
        todo.add((Object)start);
        HashSet<State> dead = new HashSet<State>();
        WorkSet live = new WorkSet();
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            if (state.isAccepting()) {
                live.add((Object)state);
            } else {
                dead.add(state);
            }
            for (Transition transition : state.out()) {
                todo.add((Object)transition.getTarget());
            }
        }
        while (!live.isEmpty()) {
            State current = (State)live.remove();
            for (Transition liveTransition : current.in()) {
                State nextLive = liveTransition.getOrigin();
                live.add((Object)nextLive);
                dead.remove(nextLive);
            }
        }
        dead.remove(start);
        live.remove((Object)start);
        live.getDone().add(start);
        if (error != null) {
            dead.remove(error);
            live.remove((Object)error);
            live.getDone().add(error);
        }
        for (State current : dead) {
            current.disconnect();
        }
        return live.getDone().toArray(new State[0]);
    }

    private static int order(State[] states) {
        int left = 0;
        int right = states.length - 1;
        while (left <= right) {
            while (left < states.length && !states[left].isAccepting()) {
                states[left].setId(left);
                ++left;
            }
            while (right >= 0 && states[right].isAccepting()) {
                states[right].setId(right);
                --right;
            }
            if (left >= right) continue;
            State temp = states[right];
            states[right] = states[left];
            states[left] = temp;
        }
        return right + 1;
    }

    public void prune() {
        this.eliminateTrivialEpsilons();
        this.mergeTransitions();
    }

    public void determinize() {
        this.eliminateAllEpsilons();
        this.mergeTransitions();
        this.determinizeStates();
        this.totalizeStates();
        this.minimizeStates();
    }

    private void totalizeStates() {
        State error = new State();
        WorkSet todo = new WorkSet();
        todo.add(error);
        todo.add(this.start);
        while (!todo.isEmpty()) {
            State current = (State)todo.remove();
            LinkedList<ByteRange> missingRanges = new LinkedList<ByteRange>(this.byteRanges);
            block1: for (Transition transition : current.out()) {
                todo.add(transition.getTarget());
                if (!(transition instanceof OrdinaryTransition)) continue;
                byte b = ((OrdinaryTransition)transition).getFrom();
                Iterator iterator = missingRanges.iterator();
                while (iterator.hasNext()) {
                    ByteRange check = (ByteRange)iterator.next();
                    if (!check.contains(new byte[]{b})) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            for (ByteRange range : missingRanges) {
                new BytesTransition(current, range.from[0], range.to[0], error).connect();
            }
        }
        this.init(this.start, error);
    }

    private void minimizeStates() {
        LinkedList<Set<State>> partitions = new LinkedList<Set<State>>();
        LinkedList<Set<State>> todo = new LinkedList<Set<State>>();
        SplitPartition initialPartition = this.initialPartition();
        if (initialPartition.min.isEmpty()) {
            partitions.add(initialPartition.max);
        } else {
            partitions.add(initialPartition.max);
            partitions.add(initialPartition.min);
            todo.add(initialPartition.min);
        }
        while (!todo.isEmpty()) {
            Set current = (Set)todo.remove();
            for (ByteRange charRange : this.byteRanges) {
                Set<State> origins = this.origins(current, charRange);
                ListIterator<Set<State>> partitionIterator = partitions.listIterator();
                while (partitionIterator.hasNext()) {
                    Set partition = (Set)partitionIterator.next();
                    SplitPartition splitPartition = this.split(partition, origins);
                    if (splitPartition.min.isEmpty()) continue;
                    partitionIterator.set(splitPartition.max);
                    partitionIterator.add(splitPartition.min);
                    if (todo.contains(partition)) {
                        todo.remove(partition);
                        todo.add(splitPartition.max);
                        todo.add(splitPartition.min);
                        continue;
                    }
                    todo.add(splitPartition.min);
                }
            }
        }
        State newstart = this.digest(partitions);
        this.init(newstart);
    }

    private State digest(List<Set<State>> partitions) {
        IdentityHashMap<State, State> mapping = new IdentityHashMap<State, State>();
        State start = null;
        for (Set<State> partition : partitions) {
            State state = new State();
            for (State partstate : partition) {
                mapping.put(partstate, state);
                if (partstate.isAccepting()) {
                    state.setAccepting();
                }
                if (!partstate.isSilent()) {
                    state.setSilent(false);
                }
                if (partstate != this.start) continue;
                start = state;
            }
        }
        for (Set<State> partition : partitions) {
            State representative = partition.iterator().next();
            for (Transition transition : representative.out()) {
                State origin = transition.getOrigin();
                State mappedOrigin = (State)mapping.get(origin);
                State target = transition.getTarget();
                State mappedTarget = (State)mapping.get(target);
                transition.asPrototype().withOrigin(mappedOrigin).withTarget(mappedTarget).connect();
            }
        }
        return start;
    }

    private SplitPartition split(Set<State> partition, Set<State> splitter) {
        HashSet<State> intersection = new HashSet<State>(partition.size());
        HashSet<State> remainder = new HashSet<State>(partition.size());
        for (State state : partition) {
            if (splitter.contains(state)) {
                intersection.add(state);
                continue;
            }
            remainder.add(state);
        }
        return new SplitPartition(intersection, remainder);
    }

    private Set<State> origins(Set<State> states, ByteRange byteRange) {
        HashSet<State> in = new HashSet<State>();
        for (State state : states) {
            for (Transition transition : state.in()) {
                if (!(transition instanceof OrdinaryTransition) || !((OrdinaryTransition)transition).accepts(byteRange.from[0])) continue;
                in.add(transition.getOrigin());
            }
        }
        return in;
    }

    private SplitPartition initialPartition() {
        HashSet<State> accept = new HashSet<State>(this.states.length);
        HashSet<State> nonaccept = new HashSet<State>(this.states.length);
        for (State state : this.states) {
            if (state.isAccepting()) {
                accept.add(state);
                continue;
            }
            nonaccept.add(state);
        }
        return new SplitPartition(accept, nonaccept);
    }

    private void determinizeStates() {
        HashMap dStates = new HashMap();
        WorkSet todo = new WorkSet();
        HashSet<State> startset = new HashSet<State>();
        startset.add(this.start);
        todo.add(startset);
        State dStart = new State();
        dStates.put(startset, dStart);
        while (!todo.isEmpty()) {
            Set current = (Set)todo.remove();
            State dState = (State)dStates.get(current);
            this.transferAccept(current, dState);
            for (ByteRange range : this.byteRanges) {
                byte from = range.from[0];
                byte to = range.to[0];
                HashSet<State> nextset = new HashSet<State>();
                for (State state : current) {
                    for (Transition transition : state.out()) {
                        if (!(transition instanceof OrdinaryTransition) || !((OrdinaryTransition)transition).accepts(from)) continue;
                        nextset.add(transition.getTarget());
                    }
                }
                State target = (State)dStates.get(nextset);
                if (target == null) {
                    todo.add(nextset);
                    target = new State();
                    dStates.put(nextset, target);
                }
                if (from == to) {
                    new ByteTransition(dState, from, target).connect();
                    continue;
                }
                new BytesTransition(dState, from, to, target).connect();
            }
        }
        this.init(dStart);
    }

    private void transferAccept(Set<State> states, State dState) {
        boolean accepting = false;
        boolean silent = true;
        for (State state : states) {
            accepting |= state.isAccepting();
            silent &= state.isSilent();
        }
        dState.setAccepting(accepting);
        dState.setSilent(silent);
    }

    private static List<ByteRange> computeEquivalentByteRanges(State start) {
        ByteRangeAccumulator acc = new ByteRangeAccumulator();
        WorkSet todo = new WorkSet();
        todo.add(start);
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            for (Transition transition : state.out()) {
                if (transition instanceof OrdinaryTransition) {
                    OrdinaryTransition ordinaryTransition = (OrdinaryTransition)transition;
                    acc.split(ordinaryTransition.getFrom(), ordinaryTransition.getTo());
                }
                todo.add(transition.getTarget());
            }
        }
        return acc.getRanges();
    }

    private void mergeTransitions() {
        WorkSet todo = new WorkSet();
        todo.add(this.start);
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            TreeSet<Transition> transitions = new TreeSet<Transition>(new TransitionComparator());
            transitions.addAll(state.out());
            Transition last = null;
            for (Transition transition : transitions) {
                if (last == null) {
                    last = transition;
                    continue;
                }
                Transition joined = this.tryJoin(last, transition);
                if (joined == null) {
                    if (!transitions.contains(last)) {
                        last.connect();
                    }
                    last = transition;
                    continue;
                }
                if (joined == last) {
                    transition.remove();
                    continue;
                }
                if (joined == transition) {
                    if (transitions.contains(last)) {
                        last.remove();
                    }
                    last = joined;
                    continue;
                }
                if (transitions.contains(last)) {
                    last.remove();
                }
                transition.remove();
                last = joined;
            }
            if (last == null || transitions.contains(last)) continue;
            last.connect();
        }
        NFA.clean(this.start, null);
    }

    private Transition tryJoin(Transition t1, Transition t2) {
        if (t1.getTarget() != t2.getTarget() || t1.getOrigin() != t2.getOrigin()) {
            return null;
        }
        State origin = t1.getOrigin();
        State target = t1.getTarget();
        if (t1 instanceof EpsilonTransition && t2 instanceof EpsilonTransition) {
            return new EpsilonTransition(origin, target);
        }
        if (t1 instanceof OrdinaryTransition && t2 instanceof OrdinaryTransition) {
            OrdinaryTransition ot1 = (OrdinaryTransition)t1;
            OrdinaryTransition ot2 = (OrdinaryTransition)t2;
            int from1 = ot1.getFrom() & 0xFF;
            int to1 = ot1.getTo() & 0xFF;
            int from2 = ot2.getFrom() & 0xFF;
            int to2 = ot2.getTo() & 0xFF;
            if (from2 >= from1 && from2 <= to1 + 1 || from1 >= from2 && from1 <= to2 + 1) {
                byte from = (byte)Math.min(from1, from2);
                byte to = (byte)Math.max(to1, to2);
                if (from1 == from && to1 == to) {
                    return ot1;
                }
                if (from2 == from && to2 == to) {
                    return ot2;
                }
                return new BytesTransition(origin, from, to, target);
            }
        }
        return null;
    }

    private void eliminateTrivialEpsilons() {
        WorkSet todo = new WorkSet();
        todo.add(this.start);
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            for (Transition transition : state.out()) {
                todo.add(transition.getTarget());
            }
            for (EpsilonTransition epsilon : this.transitiveEpsilons(state)) {
                State target;
                State origin = epsilon.getOrigin();
                if (origin == state) {
                    epsilon.remove();
                }
                if ((target = epsilon.getTarget()).isAccepting()) {
                    state.setAccepting();
                }
                if (!target.isSilent()) {
                    state.setSilent(false);
                }
                for (Transition transition : target.out()) {
                    if (!(transition instanceof OrdinaryTransition)) continue;
                    transition.asPrototype().withOrigin(state).withTarget(transition.getTarget()).connect();
                }
                for (Transition transition : target.out()) {
                    Action action;
                    if (!(transition instanceof EpsilonTransition) || (action = transition.getAction()) == null) continue;
                    transition.asPrototype().withOrigin(state).withTarget(transition.getTarget()).withAction(action).connect();
                }
            }
        }
        this.init(this.start);
    }

    private Set<EpsilonTransition> transitiveEpsilons(State state) {
        WorkSet todo = new WorkSet();
        for (Transition transition : state.out()) {
            if (!(transition instanceof EpsilonTransition)) continue;
            todo.add((Object)((EpsilonTransition)transition));
        }
        while (!todo.isEmpty()) {
            EpsilonTransition current = (EpsilonTransition)todo.remove();
            if (current.getAction() != null) {
                todo.remove((Object)current);
                continue;
            }
            State target = current.getTarget();
            for (Transition transition : target.out()) {
                if (!(transition instanceof EpsilonTransition)) continue;
                todo.add((Object)((EpsilonTransition)transition));
            }
        }
        return todo.getDone();
    }

    private void eliminateAllEpsilons() {
        EpsilonTransition epsilon;
        LinkedList<EpsilonTransition> epsilons = new LinkedList<EpsilonTransition>();
        WorkSet todo = new WorkSet();
        todo.add(this.start);
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            for (Transition transition : state.out()) {
                todo.add(transition.getTarget());
                if (!(transition instanceof EpsilonTransition)) continue;
                epsilons.add((EpsilonTransition)transition);
            }
        }
        WorkSet propagateEpsilons = new WorkSet();
        propagateEpsilons.addAll(epsilons);
        while (!propagateEpsilons.isEmpty()) {
            epsilon = (EpsilonTransition)propagateEpsilons.remove();
            Set<EpsilonTransition> done = this.propagateStates(epsilon);
            propagateEpsilons.removeAll(done);
            propagateEpsilons.getDone().addAll(done);
        }
        while (!epsilons.isEmpty()) {
            epsilon = (EpsilonTransition)epsilons.remove();
            State origin = epsilon.getOrigin();
            State target = epsilon.getTarget();
            int in = origin.in().size();
            int out = target.out().size();
            if (origin == this.start) {
                this.eliminateForward(epsilon);
                continue;
            }
            if (in >= out) {
                this.eliminateForward(epsilon);
                continue;
            }
            this.eliminateBackward(epsilon);
        }
        this.init(this.start);
    }

    private Set<EpsilonTransition> propagateStates(EpsilonTransition epsilon) {
        boolean accepting = false;
        boolean silent = true;
        HashSet<EpsilonTransition> propagated = new HashSet<EpsilonTransition>();
        WorkSet eclosure = new WorkSet();
        eclosure.add((Object)epsilon.getOrigin());
        eclosure.add((Object)epsilon.getTarget());
        while (!eclosure.isEmpty()) {
            State next = (State)eclosure.remove();
            accepting |= next.isAccepting();
            silent &= next.isSilent();
            for (Transition transition : next.out()) {
                if (!(transition instanceof EpsilonTransition)) continue;
                propagated.add((EpsilonTransition)transition);
                eclosure.add((Object)transition.getTarget());
            }
            for (Transition transition : next.in()) {
                if (!(transition instanceof EpsilonTransition)) continue;
                propagated.add((EpsilonTransition)transition);
                eclosure.add((Object)transition.getOrigin());
            }
        }
        for (State state : eclosure.getDone()) {
            state.setAccepting(accepting);
            state.setSilent(silent);
        }
        return propagated;
    }

    private void eliminateForward(EpsilonTransition epsilon) {
        State origin = epsilon.getOrigin();
        WorkSet targets = new WorkSet();
        targets.add((Object)epsilon.getTarget());
        while (!targets.isEmpty()) {
            State next = (State)targets.remove();
            for (Transition transition : next.out()) {
                if (transition instanceof OrdinaryTransition) {
                    transition.asPrototype().withOrigin(origin).withTarget(transition.getTarget()).connect();
                    continue;
                }
                if (!(transition instanceof EpsilonTransition)) continue;
                targets.add((Object)transition.getTarget());
            }
        }
        epsilon.remove();
        if (origin.out().isEmpty() && !origin.isAccepting()) {
            origin.disconnect();
        }
        for (State target : targets.getDone()) {
            if (!target.in().isEmpty() || target == this.start) continue;
            target.disconnect();
        }
    }

    private void eliminateBackward(EpsilonTransition epsilon) {
        State target = epsilon.getTarget();
        WorkSet origins = new WorkSet();
        origins.add((Object)epsilon.getOrigin());
        while (!origins.isEmpty()) {
            State next = (State)origins.remove();
            for (Transition transition : next.in()) {
                if (transition instanceof OrdinaryTransition) {
                    transition.asPrototype().withOrigin(transition.getOrigin()).withTarget(target).connect();
                    continue;
                }
                if (!(transition instanceof EpsilonTransition)) continue;
                origins.add((Object)transition.getOrigin());
            }
        }
        epsilon.remove();
        if (target.in().isEmpty() && target != this.start) {
            target.disconnect();
        }
        for (State origin : origins.getDone()) {
            if (!origin.out().isEmpty()) continue;
            origin.disconnect();
        }
    }

    public NFA clone() {
        try {
            NFA nfa = (NFA)super.clone();
            StateClone stateClone = StateClone.cloneTree(this.start);
            nfa.init(stateClone.getStart());
            return nfa;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private static class SplitPartition {
        public Set<State> max;
        public Set<State> min;

        public SplitPartition(Set<State> intersection, Set<State> remainder) {
            this.max = intersection.size() > remainder.size() ? intersection : remainder;
            this.min = intersection.size() <= remainder.size() ? intersection : remainder;
        }
    }

    private static class ByteRangeAccumulator {
        private List<ByteRange> ranges = Lists.of((Object[])new ByteRange[]{new ByteRange(0, -1, 256)});

        public List<ByteRange> getRanges() {
            return this.ranges;
        }

        public void split(byte from, byte to) {
            for (int i = 0; i < this.ranges.size(); ++i) {
                ByteRange currentRange = this.ranges.get(i);
                if (currentRange.contains(new byte[]{from}) && currentRange.contains(new byte[]{to})) {
                    i = this.replace(i, currentRange.splitAround(from, to));
                    continue;
                }
                if (currentRange.contains(new byte[]{from})) {
                    i = this.replace(i, currentRange.splitBefore(new byte[]{from}));
                    continue;
                }
                if (!currentRange.contains(new byte[]{to})) continue;
                i = this.replace(i, currentRange.splitAfter(new byte[]{to}));
            }
        }

        public int replace(int i, List<ByteRange> replacement) {
            this.ranges.remove(i);
            this.ranges.addAll(i, replacement);
            return i + replacement.size() - 1;
        }
    }
}

