/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.bytes;

import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFAMatcherState;
import net.amygdalum.util.io.ByteProvider;

public class Groups
implements Comparable<Groups> {
    private static final SortedSet<SubMatch> EMPTY = new TreeSet<SubMatch>();
    private long start;
    private long end;
    private SubMatch[] submatches;
    private SortedSet<SubMatch> allsubmatches;

    public Groups() {
        this.start = -1L;
        this.end = -1L;
        this.allsubmatches = EMPTY;
    }

    public Groups(long start, long end) {
        this.start = start;
        this.end = end;
        this.allsubmatches = EMPTY;
    }

    public Groups(long start, long end, SubMatch[] submatches, SortedSet<SubMatch> allsubmatches) {
        this.start = start;
        this.end = end;
        this.submatches = submatches;
        this.allsubmatches = allsubmatches;
    }

    public static Groups longest(List<Groups> groups) {
        Groups longest = null;
        for (Groups group : groups) {
            if (longest != null && longest.range() >= group.range()) continue;
            longest = group;
        }
        return longest;
    }

    public boolean isComplete() {
        return this.submatches != null;
    }

    public boolean invalid() {
        return this.start == -1L || this.end == -1L;
    }

    public boolean valid() {
        return this.start > -1L && this.end > -1L;
    }

    public boolean subsumes(Groups group) {
        return this.start <= group.start && this.end >= group.end;
    }

    public boolean overlaps(Groups group) {
        return this.start <= group.start && this.end >= group.start || this.start <= group.end && this.end >= group.end;
    }

    public long getStart() {
        return this.start;
    }

    public long getStart(int no) {
        SubMatch subMatch;
        if (this.submatches != null && no < this.submatches.length && (subMatch = this.submatches[no]) != null) {
            return subMatch.start;
        }
        return -1L;
    }

    public long getEnd() {
        return this.end;
    }

    public long getEnd(int no) {
        SubMatch subMatch;
        if (this.submatches != null && no < this.submatches.length && (subMatch = this.submatches[no]) != null) {
            return subMatch.end;
        }
        return -1L;
    }

    public long range() {
        return this.end - this.start;
    }

    public Groups startGroup(int no, long pos) {
        if (no == 0) {
            return new Groups(pos, this.end, this.submatches, this.allsubmatches);
        }
        SubMatch[] newSubmatches = this.newSubmatches(no);
        newSubmatches[no] = SubMatch.start(pos);
        return new Groups(this.start, this.end, newSubmatches, this.allsubmatches);
    }

    public Groups endGroup(int no, long pos) {
        if (no == 0) {
            return new Groups(this.start, pos, this.submatches, this.allsubmatches);
        }
        SubMatch[] newSubmatches = this.newSubmatches(no);
        TreeSet<SubMatch> newAllSubmatches = new TreeSet<SubMatch>(this.allsubmatches);
        if (newSubmatches[no] != null) {
            SubMatch newSubmatch;
            newSubmatches[no] = newSubmatch = newSubmatches[no].end(pos);
            newAllSubmatches.add(newSubmatch);
        }
        return new Groups(this.start, this.end, newSubmatches, newAllSubmatches);
    }

    public SubMatch[] newSubmatches(int no) {
        int len;
        int n = len = this.submatches == null ? 0 : this.submatches.length;
        if (len <= no) {
            len = no + 1;
        }
        SubMatch[] newsubmatches = new SubMatch[len];
        if (this.submatches != null) {
            System.arraycopy(this.submatches, 0, newsubmatches, 0, this.submatches.length);
        }
        return newsubmatches;
    }

    public void reset() {
        this.start = -1L;
        this.end = -1L;
    }

    public void update(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public void update(Groups group) {
        this.submatches = group.submatches;
        this.allsubmatches = group.allsubmatches;
    }

    public String toString() {
        return this.start + ":" + this.end + (this.submatches == null ? "" : " " + Arrays.toString(this.submatches));
    }

    @Override
    public int compareTo(Groups group) {
        int compare = Long.compare(this.start, group.start);
        if (compare == 0) {
            compare = Long.compare(this.end, group.end);
        }
        if (compare == 0) {
            compare = Groups.compareSubMatches(this.allsubmatches, group.allsubmatches);
        }
        return compare;
    }

    public int hashCode() {
        return Long.valueOf(this.start).hashCode() * 7 + Long.valueOf(this.end).hashCode() * 5 + this.allsubmatches.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Groups that = (Groups)obj;
        return this.start == that.start && this.end == that.end && Arrays.equals(this.submatches, that.submatches) && this.allsubmatches.equals(that.allsubmatches);
    }

    public void process(ByteProvider input, NFA grouper) {
        long groupStart = this.start;
        NFAMatcherState state = NFAMatcherState.of(grouper.getStart(), new Groups(), groupStart);
        input.move(groupStart);
        while (!input.finished() && input.current() < this.getEnd()) {
            byte b = input.next();
            long current = input.current();
            state = state.next(b, current);
        }
        this.update(state.getGroups().first());
    }

    private static int compareSubMatches(SortedSet<SubMatch> submatches1, SortedSet<SubMatch> submatches2) {
        PriorityQueue<SubMatch> sub1 = new PriorityQueue<SubMatch>(submatches1);
        PriorityQueue<SubMatch> sub2 = new PriorityQueue<SubMatch>(submatches2);
        while (!sub1.isEmpty() && !sub2.isEmpty()) {
            SubMatch match1 = (SubMatch)sub1.remove();
            SubMatch match2 = (SubMatch)sub2.remove();
            int compare = match2.compareTo(match1);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static class SubMatch
    implements Comparable<SubMatch> {
        public long start;
        public long end;

        private SubMatch(long start) {
            this.start = start;
        }

        private SubMatch(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public static SubMatch start(long start) {
            return new SubMatch(start);
        }

        public SubMatch end(long end) {
            return new SubMatch(this.start, end);
        }

        public String toString() {
            return this.start + ":" + this.end;
        }

        @Override
        public int compareTo(SubMatch submatch) {
            int compare = Long.compare(this.start, submatch.start);
            if (compare == 0) {
                compare = Long.compare(this.end, submatch.end);
            }
            return compare;
        }

        public int hashCode() {
            return Long.valueOf(this.start).hashCode() * 17 + Long.valueOf(this.end).hashCode() * 13;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubMatch that = (SubMatch)obj;
            return this.start == that.start && this.end == that.end;
        }
    }
}

