/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.bytes;

import java.util.Arrays;
import java.util.Comparator;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.OrdinaryTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.State;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Transition;

public class DFA {
    public int start;
    public int accepting;
    public int silent;
    public int[] transitions;

    public DFA(int start, int accepting, int silent, int[] transitions) {
        this.start = start;
        this.accepting = accepting;
        this.silent = silent;
        this.transitions = transitions;
    }

    public static DFA from(NFA nfa) {
        nfa = nfa.clone();
        nfa.determinize();
        State start = nfa.getStart();
        State[] states = nfa.states();
        return new DFABuilder(start, states).build();
    }

    public int next(int s, byte b) {
        return this.transitions[s * 256 + (b & 0xFF)];
    }

    public boolean accept(int s) {
        return s >= this.accepting;
    }

    public boolean silent(int s) {
        return s <= this.silent;
    }

    private static class DFABuilder
    implements Comparator<State> {
        private State start;
        private State[] states;
        private int[] transitions;
        private int accepting;
        private int silent;

        public DFABuilder(State start, State[] states) {
            this.start = start;
            this.states = states;
        }

        private void computeTransitions() {
            int[] transitions = new int[this.states.length * 256];
            for (int i = 0; i < this.states.length; ++i) {
                block1: for (int j = 0; j < 256; ++j) {
                    byte b = (byte)j;
                    for (Transition next : this.states[i].out()) {
                        if (!(next instanceof OrdinaryTransition) || !((OrdinaryTransition)next).accepts(b)) continue;
                        transitions[i * 256 + j] = next.getTarget().getId();
                        continue block1;
                    }
                    transitions[i * 256 + j] = -1;
                }
            }
            this.transitions = transitions;
        }

        private void partitionStates() {
            Arrays.sort(this.states, this);
            this.silent = -1;
            this.accepting = 0;
            for (int i = 0; i < this.states.length; ++i) {
                this.states[i].setId(i);
                if (this.states[i].isSilent()) {
                    this.silent = i;
                }
                if (this.states[i].isAccepting()) continue;
                this.accepting = i + 1;
            }
        }

        @Override
        public int compare(State s1, State s2) {
            boolean accept2;
            boolean accept1 = s1.isAccepting();
            int compare = Boolean.compare(accept1, accept2 = s2.isAccepting());
            if (compare == 0) {
                boolean silent1 = s1.isSilent();
                boolean silent2 = s2.isSilent();
                compare = Boolean.compare(silent2, silent1);
            }
            return compare;
        }

        public DFA build() {
            this.partitionStates();
            this.computeTransitions();
            return new DFA(this.start.getId(), this.accepting, this.silent, this.transitions);
        }
    }
}

