/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern.chars;

import net.amygdalum.patternsearchalgorithms.automaton.chars.DFA;
import net.amygdalum.patternsearchalgorithms.automaton.chars.MinimalNFAComponentFactory;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFABuilder;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFAComponent;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.patternsearchalgorithms.pattern.SearchMode;
import net.amygdalum.patternsearchalgorithms.pattern.chars.MatcherFactory;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SimpleAllNonOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SimpleAllOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SimpleLongestNonOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SimpleLongestOverlappingMatcher;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.util.io.CharProvider;

public class SimpleMatcherFactory
implements MatcherFactory {
    private SearchMode mode;
    private DFA matcher;
    private NFA grouper;

    public SimpleMatcherFactory(SearchMode mode) {
        this.mode = mode;
    }

    public static SimpleMatcherFactory compile(RegexNode node, SearchMode mode) {
        return new SimpleMatcherFactory(mode).compile(node);
    }

    private SimpleMatcherFactory compile(RegexNode node) {
        this.matcher = this.matcherFrom(node);
        this.grouper = this.grouperFrom(node);
        return this;
    }

    private DFA matcherFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder(new MinimalNFAComponentFactory());
        NFA nfa = builder.build(node);
        return DFA.from(nfa);
    }

    private NFA grouperFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder();
        NFAComponent base = builder.matchGroup((NFAComponent)node.accept((RegexNodeVisitor)builder), 0);
        NFA grouper = builder.build(base);
        grouper.prune();
        return grouper;
    }

    @Override
    public Matcher newMatcher(CharProvider input) {
        if (this.mode.findLongest()) {
            if (this.mode.findOverlapping()) {
                return new SimpleLongestOverlappingMatcher(this.matcher, this.grouper, input);
            }
            return new SimpleLongestNonOverlappingMatcher(this.matcher, this.grouper, input);
        }
        if (this.mode.findOverlapping()) {
            return new SimpleAllOverlappingMatcher(this.matcher, this.grouper, input);
        }
        return new SimpleAllNonOverlappingMatcher(this.matcher, this.grouper, input);
    }
}

