/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern.bytes;

import java.nio.charset.Charset;
import java.util.Arrays;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.DFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFABuilder;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFAComponent;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.patternsearchalgorithms.pattern.SearchMode;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.MatcherFactory;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SearchAllNonOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SearchAllOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SearchLongestNonOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SearchLongestOverlappingMatcher;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.util.io.ByteProvider;

public class SearchMatcherFactory
implements MatcherFactory {
    private SearchMode mode;
    private Charset charset;
    private DFA finder;
    private DFA backmatcher;
    private NFA grouper;

    private SearchMatcherFactory(SearchMode mode, Charset charset) {
        this.mode = mode;
        this.charset = charset;
    }

    public static SearchMatcherFactory compile(RegexNode node, Charset charset, SearchMode mode) {
        return new SearchMatcherFactory(mode, charset).compile(node);
    }

    private SearchMatcherFactory compile(RegexNode node) {
        this.finder = this.finderFrom(node);
        this.backmatcher = this.backmatcherFrom(node);
        this.grouper = this.grouperFrom(node);
        return this;
    }

    private DFA finderFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder(this.charset);
        NFAComponent base = (NFAComponent)node.accept((RegexNodeVisitor)builder);
        NFAComponent selfloop = builder.matchStarLoop(builder.match('\u0000', '\uffff')).silent();
        NFAComponent finder = builder.matchConcatenation(Arrays.asList(selfloop, base));
        NFA nfa = builder.build(finder);
        return DFA.from(nfa);
    }

    private DFA backmatcherFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder(this.charset);
        NFAComponent base = (NFAComponent)node.accept((RegexNodeVisitor)builder);
        NFAComponent reverse = base.reverse();
        NFA nfa = builder.build(reverse);
        return DFA.from(nfa);
    }

    private NFA grouperFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder(this.charset);
        NFAComponent base = builder.matchGroup((NFAComponent)node.accept((RegexNodeVisitor)builder), 0);
        NFA grouper = builder.build(base);
        grouper.prune();
        return grouper;
    }

    @Override
    public Matcher newMatcher(ByteProvider input) {
        if (this.mode.findLongest()) {
            if (this.mode.findOverlapping()) {
                return new SearchLongestOverlappingMatcher(this.finder, this.backmatcher, this.grouper, input);
            }
            return new SearchLongestNonOverlappingMatcher(this.finder, this.backmatcher, this.grouper, input);
        }
        if (this.mode.findOverlapping()) {
            return new SearchAllOverlappingMatcher(this.finder, this.backmatcher, this.grouper, input);
        }
        return new SearchAllNonOverlappingMatcher(this.finder, this.backmatcher, this.grouper, input);
    }
}

