/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.chars.OrdinaryTransition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.State;
import net.amygdalum.patternsearchalgorithms.automaton.chars.Transition;
import net.amygdalum.util.io.BitMaskCharClassMapper;
import net.amygdalum.util.io.CharClassMapper;
import net.amygdalum.util.io.LowByteCharClassMapper;
import net.amygdalum.util.io.SmallRangeCharClassMapper;
import net.amygdalum.util.text.CharRange;

public class DFA {
    public int start;
    public int accepting;
    public int silent;
    public CharClassMapper mapper;
    public int[] transitions;

    public DFA(int start, int accepting, int silent, CharClassMapper mapper, int[] transitions) {
        this.start = start;
        this.accepting = accepting;
        this.silent = silent;
        this.mapper = mapper;
        this.transitions = transitions;
    }

    public static DFA from(NFA nfa) {
        nfa = nfa.clone();
        nfa.determinize();
        State start = nfa.getStart();
        State[] states = nfa.states();
        List<CharRange> ranges = nfa.getCharRanges();
        return new DFABuilder(ranges, start, states).build();
    }

    public int next(int s, char c) {
        return this.transitions[s * this.mapper.indexCount() + this.mapper.getIndex(c)];
    }

    public boolean accept(int s) {
        return s >= this.accepting;
    }

    public boolean silent(int s) {
        return s <= this.silent;
    }

    private static class DFABuilder
    implements Comparator<State> {
        private List<CharRange> liveRanges;
        private State start;
        private State[] states;
        private CharClassMapper mapper;
        private int[] transitions;
        private int accepting;
        private int silent;

        public DFABuilder(List<CharRange> ranges, State start, State[] states) {
            this.liveRanges = this.live(ranges, states);
            this.start = start;
            this.states = states;
        }

        private List<CharRange> live(List<CharRange> ranges, State[] states) {
            ArrayList<CharRange> live = new ArrayList<CharRange>();
            for (CharRange range : ranges) {
                char c = range.from;
                for (State state : states) {
                    for (Transition transition : state.out()) {
                        if (!(transition instanceof OrdinaryTransition) || !((OrdinaryTransition)transition).accepts(c)) continue;
                        live.add(range);
                    }
                }
            }
            return live;
        }

        private void computeTransitions() {
            int[] transitions = new int[this.states.length * this.mapper.indexCount()];
            for (int i = 0; i < this.states.length; ++i) {
                block1: for (int index = 0; index < this.mapper.indexCount(); ++index) {
                    char c = this.mapper.representative(index);
                    for (Transition next : this.states[i].out()) {
                        if (!(next instanceof OrdinaryTransition) || !((OrdinaryTransition)next).accepts(c)) continue;
                        transitions[i * this.mapper.indexCount() + index] = next.getTarget().getId();
                        continue block1;
                    }
                    transitions[i * this.mapper.indexCount() + index] = -1;
                }
            }
            this.transitions = transitions;
        }

        private void partitionStates() {
            Arrays.sort(this.states, this);
            this.silent = -1;
            this.accepting = 0;
            for (int i = 0; i < this.states.length; ++i) {
                this.states[i].setId(i);
                if (this.states[i].isSilent()) {
                    this.silent = i;
                }
                if (this.states[i].isAccepting()) continue;
                this.accepting = i + 1;
            }
        }

        private void computeMapper() {
            boolean lowByte = this.computeLowByte();
            boolean smallRange = this.computeSmallRange(lowByte);
            this.mapper = smallRange ? new SmallRangeCharClassMapper(this.liveRanges) : (lowByte ? new LowByteCharClassMapper(this.liveRanges) : new BitMaskCharClassMapper(this.liveRanges));
        }

        public boolean computeLowByte() {
            HashSet<Integer> highbytes = new HashSet<Integer>();
            for (CharRange range : this.liveRanges) {
                highbytes.add(range.from & 0xFF00);
                highbytes.add(range.to & 0xFF00);
            }
            return highbytes.size() <= 1;
        }

        public boolean computeSmallRange(boolean lowByte) {
            if (this.liveRanges.isEmpty()) {
                return true;
            }
            char min = this.liveRanges.get((int)0).from;
            char max = this.liveRanges.get((int)(this.liveRanges.size() - 1)).to;
            if (lowByte) {
                return max - min <= 64;
            }
            return max - min <= 256;
        }

        @Override
        public int compare(State s1, State s2) {
            boolean accept2;
            boolean accept1 = s1.isAccepting();
            int compare = Boolean.compare(accept1, accept2 = s2.isAccepting());
            if (compare == 0) {
                boolean silent1 = s1.isSilent();
                boolean silent2 = s2.isSilent();
                compare = Boolean.compare(silent2, silent1);
            }
            return compare;
        }

        public DFA build() {
            this.partitionStates();
            this.computeMapper();
            this.computeTransitions();
            return new DFA(this.start.getId(), this.accepting, this.silent, this.mapper, this.transitions);
        }
    }
}

