/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.chars;

import net.amygdalum.patternsearchalgorithms.automaton.chars.Action;
import net.amygdalum.patternsearchalgorithms.automaton.chars.Groups;
import net.amygdalum.patternsearchalgorithms.automaton.chars.State;
import net.amygdalum.patternsearchalgorithms.automaton.chars.Transition;

public abstract class AbstractTransition
implements Transition {
    private Action action;
    private State origin;
    private State target;

    public AbstractTransition(State origin, State target) {
        this.origin = origin;
        this.target = target;
    }

    @Override
    public Transition withOrigin(State origin) {
        this.origin = origin;
        return this;
    }

    @Override
    public Transition withTarget(State target) {
        this.target = target;
        return this;
    }

    @Override
    public Transition withAction(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public State getOrigin() {
        return this.origin;
    }

    @Override
    public State getTarget() {
        return this.target;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public Groups executeAction(Groups groups, long pos) {
        if (this.action == null) {
            return groups;
        }
        return this.action.applyTo(groups, pos);
    }

    @Override
    public void connect() {
        this.origin.addOut(this);
        this.target.addIn(this);
    }

    @Override
    public void remove() {
        this.origin.removeOut(this);
        this.target.removeIn(this);
    }
}

