/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.bytes;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.State;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Transition;
import net.amygdalum.util.tuples.Pair;
import net.amygdalum.util.worklist.WorkSet;

public class StateClone {
    private State start;
    private IdentityHashMap<State, State> states;

    public StateClone(State start) {
        this.start = start;
        this.states = new IdentityHashMap();
    }

    public static StateClone cloneTree(State start) {
        StateClone stateClone = new StateClone(start);
        stateClone.process();
        return stateClone;
    }

    private void process() {
        WorkSet workset = new WorkSet();
        State clonedStart = this.start.asPrototype();
        workset.add(new Pair((Object)this.start, (Object)clonedStart));
        this.states.put(this.start, clonedStart);
        while (!workset.isEmpty()) {
            Pair current = (Pair)workset.remove();
            State state = (State)current.left;
            State cloned = (State)current.right;
            List<Pair<State, State>> next = this.transferState(state, cloned);
            workset.addAll(next);
        }
    }

    private List<Pair<State, State>> transferState(State state, State cloned) {
        ArrayList<Pair<State, State>> next = new ArrayList<Pair<State, State>>();
        if (state.isAccepting()) {
            cloned.setAccepting();
        }
        if (state.isSilent()) {
            cloned.setSilent();
        }
        for (Transition transition : state.out()) {
            State target = transition.getTarget();
            State clonedtarget = this.states.get(target);
            if (clonedtarget == null) {
                clonedtarget = target.asPrototype();
                this.states.put(target, clonedtarget);
                next.add((Pair<State, State>)new Pair((Object)target, (Object)clonedtarget));
            }
            Transition clonedtransition = transition.asPrototype().withOrigin(cloned).withTarget(clonedtarget);
            clonedtransition.connect();
        }
        return next;
    }

    public State get(State state) {
        return this.states.get(state);
    }

    public State getStart() {
        return this.states.get(this.start);
    }
}

