/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.utils;

import java.text.NumberFormat;
import java.util.Locale;

public final class MessageValues {
    private static final NumberFormat FORMAT = MessageValues.numberFormat();

    private MessageValues() {
    }

    private static NumberFormat numberFormat() {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat;
    }

    public static String value(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return "\"" + MessageValues.escape(string) + "\"";
        }
        if (value instanceof Double) {
            Double dvalue = (Double)value;
            return FORMAT.format(dvalue);
        }
        if (!value.getClass().isPrimitive()) {
            return "<" + value.toString() + ">";
        }
        return value.toString();
    }

    private static String escape(String raw) {
        return raw.replaceAll("\"", "\\\"");
    }
}

