/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.allotropy.fluent.elements.VisualElement;

public final class AssertionErrors {
    private AssertionErrors() {
    }

    public static Builder expected(Object element) {
        return new Builder().expected(element);
    }

    @SafeVarargs
    public static <T> Builder expectedAllOf(T ... elements) {
        return AssertionErrors.expectedAllOf(Arrays.asList(elements));
    }

    public static <T> Builder expectedAllOf(List<T> elements) {
        return new Builder().expectedAllOf(elements);
    }

    public static class Builder {
        private StringBuilder builder = new StringBuilder();

        public <T> Builder expectedAllOf(List<T> objects) {
            this.builder.append(" expected all of [").append(objects.stream().map(Object::toString).collect(Collectors.joining(", "))).append("]");
            return this;
        }

        public Builder expected(Object object) {
            this.builder.append(" expected ").append(object);
            return this;
        }

        public <T> Builder of(Object object) {
            this.builder.append(" of ").append(object);
            return this;
        }

        public <T> Builder of(List<T> objects) {
            this.builder.append(" of [").append(objects.stream().map(Object::toString).collect(Collectors.joining(", "))).append("]");
            return this;
        }

        public Builder and(Object object) {
            this.builder.append(" and ").append(object);
            return this;
        }

        public Builder to(Object object) {
            this.builder.append(" to ").append(object);
            return this;
        }

        public Builder aligned(Object object) {
            this.builder.append(" aligned ").append(object);
            return this;
        }

        public Builder toBe(Object object) {
            this.builder.append(" to be ").append(object);
            return this;
        }

        public Builder toHave(Object object) {
            this.builder.append(" to have ").append(object);
            return this;
        }

        public Builder butWere(Object object) {
            this.builder.append(" but were ").append(object);
            return this;
        }

        public Builder butWas(Object object) {
            this.builder.append(" but was ").append(object);
            return this;
        }

        public Builder at(Object object) {
            this.builder.append(" at ").append(object);
            return this;
        }

        public Builder __(Object object) {
            this.builder.append(" ").append(object);
            return this;
        }

        public Builder butFailed() {
            this.builder.append(" but failed");
            return this;
        }

        public Builder butFound(Object object) {
            this.builder.append(" but found ").append(object);
            return this;
        }

        public Builder butNot(Object object) {
            this.builder.append(" but not ").append(object);
            return this;
        }

        public Builder butNotAt(Object object) {
            this.builder.append(" but not at ").append(object);
            return this;
        }

        public Builder insideOf(VisualElement object) {
            this.builder.append(" inside of ").append(object);
            return this;
        }

        public Builder startingWith(Object object) {
            this.builder.append(" starting with ").append(object);
            return this;
        }

        public Builder endingWith(Object object) {
            this.builder.append(" ending with ").append(object);
            return this;
        }

        public Builder containing(Object object) {
            this.builder.append(" containing ").append(object);
            return this;
        }

        public Builder overlapping(Object object) {
            this.builder.append(" containing ").append(object);
            return this;
        }

        public Builder with(Object object) {
            this.builder.append(" with ").append(object);
            return this;
        }

        public String message() {
            return this.builder.append(".").toString().trim();
        }

        public AssertionError asAssertionError() {
            return new AssertionError((Object)this.message());
        }
    }
}

