/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.utils;

import java.lang.reflect.Array;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class Arrays {
    private Arrays() {
    }

    public static <T> Collector<T, ArrayBuilder<T>, T[]> toArray() {
        return Collector.of(ArrayBuilder::new, ArrayBuilder::accept, ArrayBuilder::merge, ArrayBuilder::finish, new Collector.Characteristics[0]);
    }

    private static class ArrayBuilder<T> {
        private Stream.Builder<T> builder = Stream.builder();
        private Class<T> clazz;

        public ArrayBuilder<T> accept(T element) {
            Class<?> subjectClass = element.getClass();
            if (this.clazz == null) {
                this.clazz = subjectClass;
            } else if (subjectClass != this.clazz) {
                throw new IllegalArgumentException("expecting all elements of same type, but found multiple types");
            }
            this.builder.add(element);
            return this;
        }

        public ArrayBuilder<T> merge(ArrayBuilder<T> that) {
            if (this.clazz == null) {
                return that;
            }
            if (that.clazz == null) {
                return this;
            }
            if (this.clazz != that.clazz) {
                throw new IllegalArgumentException("expecting all elements of same type, but found multiple types");
            }
            that.builder.build().forEach(this.builder::add);
            return this;
        }

        public T[] finish() {
            return this.builder.build().toArray(i -> this.newArray(i));
        }

        private T[] newArray(int i) {
            return (Object[])Array.newInstance(this.clazz, i);
        }
    }
}

