/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.styles;

import java.util.function.Function;
import net.amygdalum.allotropy.fluent.elements.StyleableElement;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.single.DefaultStyleAssert;
import net.amygdalum.allotropy.fluent.single.QuitableStyleAssert;
import net.amygdalum.allotropy.fluent.styles.StyleConstrainingAssert;
import net.amygdalum.allotropy.fluent.styles.StyleConstraint;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;
import net.amygdalum.allotropy.fluent.utils.MessageValues;

public class DefaultStyleConstrainingAssert<T extends VisualElement>
implements StyleConstrainingAssert<T> {
    private T subject;
    private String attribute;
    private Function<String, String> mapping;

    public DefaultStyleConstrainingAssert(T subject, String attribute) {
        this.subject = subject;
        this.attribute = attribute;
        this.mapping = Function.identity();
    }

    @Override
    public StyleConstrainingAssert<T> mappedTo(Function<String, String> mapping) {
        this.mapping = this.mapping.andThen(mapping);
        return this;
    }

    @Override
    public QuitableStyleAssert<T> satisfies(StyleConstraint constraint) {
        T t = this.subject;
        if (t instanceof StyleableElement) {
            StyleableElement styled = (StyleableElement)t;
            String foundValue = this.mapping.apply(styled.style(this.attribute));
            if (!constraint.test(foundValue)) {
                throw AssertionErrors.expected(this.subject).toHave(this.attribute).__(constraint.description()).butFound(MessageValues.value(foundValue)).asAssertionError();
            }
        } else {
            throw new IllegalArgumentException("style asserts are only possible on VisualElements with interface facet StyleableElement");
        }
        return new DefaultStyleAssert<T>(this.subject);
    }
}

