/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import java.util.function.Consumer;
import java.util.function.Function;
import net.amygdalum.allotropy.fluent.common.Assert;
import net.amygdalum.allotropy.fluent.common.Constraint;
import net.amygdalum.allotropy.fluent.conditions.PresenceConstraint;
import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.directions.LayerRelation;
import net.amygdalum.allotropy.fluent.elements.AsVisualElement;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.multiple.VisualElementsAssert;
import net.amygdalum.allotropy.fluent.single.AlignedAssert;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.AtAssert;
import net.amygdalum.allotropy.fluent.single.ContainsAssert;
import net.amygdalum.allotropy.fluent.single.DimensionalAssert;
import net.amygdalum.allotropy.fluent.single.InsideAssert;
import net.amygdalum.allotropy.fluent.single.LayerAssert;
import net.amygdalum.allotropy.fluent.single.OverlapsAssert;
import net.amygdalum.allotropy.fluent.single.StyleAssert;
import net.amygdalum.allotropy.fluent.single.TextAssert;

public interface VisualElementAssert<T extends VisualElement>
extends Assert {
    default public AtAssert<T> above() {
        return this.at().top();
    }

    default public AtAssert<T> below() {
        return this.at().bottom();
    }

    default public AtAssert<T> left() {
        return this.at().left();
    }

    default public AtAssert<T> right() {
        return this.at().right();
    }

    public AtAssert<T> at();

    public InsideAssert<T> inside();

    public OverlapsAssert<T> overlaps();

    default public AndAssert<T> contains(AsVisualElement<?> ... items) {
        return this.contains().items(items);
    }

    public ContainsAssert<T> contains();

    default public LayerAssert<T> front() {
        return this.layered(LayerRelation.FRONT);
    }

    default public LayerAssert<T> behind() {
        return this.layered(LayerRelation.BEHIND);
    }

    public LayerAssert<T> layered(LayerRelation var1);

    default public DimensionalAssert<T> width() {
        return this.hasDimension(Dimension.HORIZONTAL);
    }

    default public DimensionalAssert<T> height() {
        return this.hasDimension(Dimension.VERTICAL);
    }

    public DimensionalAssert<T> hasDimension(Dimension var1);

    public AlignedAssert<T> alignedVertically();

    public AlignedAssert<T> alignedHorizontally();

    public TextAssert<T> text();

    public StyleAssert<T> effectiveStyle();

    default public AndAssert<T> isPresent() {
        return this.property(PresenceConstraint.isPresent());
    }

    default public AndAssert<T> isAbsent() {
        return this.property(PresenceConstraint.isAbsent());
    }

    public AndAssert<T> property(Constraint<VisualElement> var1);

    public <S extends VisualElement> AndAssert<T> select(Function<T, S> var1, Consumer<VisualElementAssert<S>> var2);

    public <S extends VisualElement> AndAssert<T> spread(Function<T, S[]> var1, Consumer<VisualElementsAssert<S>> var2);
}

