/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import net.amygdalum.allotropy.fluent.directions.LayerRelation;
import net.amygdalum.allotropy.fluent.elements.LayerableElement;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.single.LayerAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;

public class DefaultlayerAssert<T extends VisualElement>
implements LayerAssert<T> {
    private T subject;
    private LayerRelation relation;

    public DefaultlayerAssert(T subject, LayerRelation relation) {
        this.subject = subject;
        this.relation = relation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AndAssert<T> ofElement(VisualElement object) {
        T t = this.subject;
        if (!(t instanceof LayerableElement)) throw new IllegalArgumentException("layer asserts are only possible on VisualElements with interface facet LayerableElement");
        LayerableElement s = (LayerableElement)t;
        if (!(object instanceof LayerableElement)) throw new IllegalArgumentException("layer asserts are only possible on VisualElements with interface facet LayerableElement");
        LayerableElement o = (LayerableElement)((Object)object);
        int comparison = s.layer().compareTo(o.layer());
        if (comparison < 0 && this.relation == LayerRelation.FRONT || comparison > 0 && this.relation == LayerRelation.BEHIND) {
            throw AssertionErrors.expected(this.subject).__(this.relation.label()).of(object).butWas("not").asAssertionError();
        }
        if (comparison != 0) return new DefaultAndAssert<T>(this.subject);
        throw AssertionErrors.expected(this.subject).__(this.relation.label()).of(object).butWas("independent").asAssertionError();
    }
}

