/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import java.util.function.Consumer;
import java.util.function.Function;
import net.amygdalum.allotropy.fluent.common.Constraint;
import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.directions.LayerRelation;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.multiple.DefaultVisualElementsAssert;
import net.amygdalum.allotropy.fluent.multiple.VisualElementsAssert;
import net.amygdalum.allotropy.fluent.single.AlignedAssert;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.AtAssert;
import net.amygdalum.allotropy.fluent.single.ContainsAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAlignedAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAtAssert;
import net.amygdalum.allotropy.fluent.single.DefaultContainsAssert;
import net.amygdalum.allotropy.fluent.single.DefaultDimensionalAssert;
import net.amygdalum.allotropy.fluent.single.DefaultInsideAssert;
import net.amygdalum.allotropy.fluent.single.DefaultOverlapsAssert;
import net.amygdalum.allotropy.fluent.single.DefaultStyleAssert;
import net.amygdalum.allotropy.fluent.single.DefaultTextAssert;
import net.amygdalum.allotropy.fluent.single.DefaultlayerAssert;
import net.amygdalum.allotropy.fluent.single.DimensionalAssert;
import net.amygdalum.allotropy.fluent.single.InsideAssert;
import net.amygdalum.allotropy.fluent.single.LayerAssert;
import net.amygdalum.allotropy.fluent.single.OverlapsAssert;
import net.amygdalum.allotropy.fluent.single.StyleAssert;
import net.amygdalum.allotropy.fluent.single.TextAssert;
import net.amygdalum.allotropy.fluent.single.VisualElementAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;

public class DefaultVisualElementAssert<T extends VisualElement>
implements VisualElementAssert<T> {
    private T subject;

    public DefaultVisualElementAssert(T subject) {
        this.subject = subject;
    }

    @Override
    public AtAssert<T> at() {
        return new DefaultAtAssert<T>(this.subject);
    }

    @Override
    public InsideAssert<T> inside() {
        return new DefaultInsideAssert<T>(this.subject);
    }

    @Override
    public OverlapsAssert<T> overlaps() {
        return new DefaultOverlapsAssert<T>(this.subject);
    }

    @Override
    public ContainsAssert<T> contains() {
        return new DefaultContainsAssert<T>(this.subject);
    }

    @Override
    public LayerAssert<T> layered(LayerRelation direction) {
        return new DefaultlayerAssert<T>(this.subject, direction);
    }

    @Override
    public DimensionalAssert<T> hasDimension(Dimension dimension) {
        return new DefaultDimensionalAssert<T>(this.subject, dimension);
    }

    @Override
    public AlignedAssert<T> alignedVertically() {
        return new DefaultAlignedAssert<T>(this.subject, Dimension.VERTICAL);
    }

    @Override
    public AlignedAssert<T> alignedHorizontally() {
        return new DefaultAlignedAssert<T>(this.subject, Dimension.HORIZONTAL);
    }

    @Override
    public StyleAssert<T> effectiveStyle() {
        return new DefaultStyleAssert<T>(this.subject);
    }

    @Override
    public TextAssert<T> text() {
        return new DefaultTextAssert<T>(this.subject);
    }

    @Override
    public AndAssert<T> property(Constraint<VisualElement> condition) {
        if (!condition.test((VisualElement)this.subject)) {
            throw AssertionErrors.expected(this.subject).toBe(condition.description()).butWas("not").asAssertionError();
        }
        return new DefaultAndAssert<T>(this.subject);
    }

    @Override
    public <S extends VisualElement> AndAssert<T> select(Function<T, S> selector, Consumer<VisualElementAssert<S>> selectedAssert) {
        selectedAssert.accept(new DefaultVisualElementAssert<VisualElement>((VisualElement)selector.apply(this.subject)));
        return new DefaultAndAssert<T>(this.subject);
    }

    @Override
    public <S extends VisualElement> AndAssert<T> spread(Function<T, S[]> selector, Consumer<VisualElementsAssert<S>> selectedAssert) {
        selectedAssert.accept(new DefaultVisualElementsAssert((VisualElement[])selector.apply(this.subject)));
        return new DefaultAndAssert<T>(this.subject);
    }
}

