/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import java.util.function.Function;
import net.amygdalum.allotropy.fluent.elements.TextContainingElement;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.single.DefaultVisualElementAssert;
import net.amygdalum.allotropy.fluent.single.QuitableTextAssert;
import net.amygdalum.allotropy.fluent.single.TextAssert;
import net.amygdalum.allotropy.fluent.single.VisualElementAssert;
import net.amygdalum.allotropy.fluent.text.TextConstraint;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;
import net.amygdalum.allotropy.fluent.utils.MessageValues;

public class DefaultTextAssert<T extends VisualElement>
implements QuitableTextAssert<T> {
    private T subject;
    private Function<String, String> mapping;

    public DefaultTextAssert(T subject) {
        this.subject = subject;
        this.mapping = Function.identity();
    }

    @Override
    public TextAssert<T> mappedTo(Function<String, String> mapping) {
        this.mapping = this.mapping.andThen(mapping);
        return this;
    }

    @Override
    public QuitableTextAssert<T> satisfies(TextConstraint constraint) {
        T t = this.subject;
        if (t instanceof TextContainingElement) {
            TextContainingElement textContainer = (TextContainingElement)t;
            String text = this.mapping.apply(textContainer.text());
            if (!constraint.test(text)) {
                throw AssertionErrors.expected(this.subject).toHave("text").__(constraint.description()).butWas(MessageValues.value(textContainer.text())).asAssertionError();
            }
        } else {
            throw new IllegalArgumentException("text asserts are only possible on VisualElements with interface facet TextContainingElement");
        }
        return this;
    }

    @Override
    public VisualElementAssert<T> and() {
        return new DefaultVisualElementAssert<T>(this.subject);
    }
}

