/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.allotropy.fluent.directional.DirectionalDistanceConstraint;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.directions.Directed;
import net.amygdalum.allotropy.fluent.distances.PixelDistance;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.elements.VisualOperand;
import net.amygdalum.allotropy.fluent.precision.Precision;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.single.OverlapsAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;

public class DefaultOverlapsAssert<T extends VisualElement>
implements OverlapsAssert<T> {
    private T subject;
    private List<DirectionalDistanceConstraint> overlapConstraints;
    private Precision precision;

    public DefaultOverlapsAssert(T subject) {
        this.subject = subject;
        this.overlapConstraints = new ArrayList<DirectionalDistanceConstraint>();
        this.precision = Precision.exact();
    }

    @Override
    public AndAssert<VisualElement> withElement(VisualElement object) {
        VisualOperand o;
        VisualOperand s = VisualOperand.op(this.subject);
        if (s.inside(o = VisualOperand.op(object))) {
            throw AssertionErrors.expected(this.subject).overlapping(object).butWas("inside").asAssertionError();
        }
        if (s.outside(o)) {
            throw AssertionErrors.expected(this.subject).overlapping(object).butWas("outside").asAssertionError();
        }
        if (s.around(o)) {
            throw AssertionErrors.expected(this.subject).overlapping(object).butWas("containing").asAssertionError();
        }
        List<Directed<PixelDistance>> distances = List.of(Directed.at(CardinalDirection.N).distance(new PixelDistance(-s.topDistanceToBottom(o))), Directed.at(CardinalDirection.E).distance(new PixelDistance(-s.rightDistanceToLeft(o))), Directed.at(CardinalDirection.S).distance(new PixelDistance(-s.bottomDistanceToTop(o))), Directed.at(CardinalDirection.W).distance(new PixelDistance(-s.leftDistanceToRight(o))));
        List<Directed> violatedConstraints = distances.stream().filter(d -> this.overlapConstraints.stream().filter(c -> c.test(d.direction())).findFirst().map(c -> !c.test(d.subject())).orElse(false)).toList();
        if (!violatedConstraints.isEmpty()) {
            throw AssertionErrors.expected(this.subject).containing(object).with("distance").__(this.overlapConstraints.stream().map(d -> d.description()).collect(Collectors.joining(", "))).butWas(violatedConstraints.stream().map(d -> d.subject() + " " + d.direction().label()).collect(Collectors.joining(", "))).asAssertionError();
        }
        return new DefaultAndAssert<VisualElement>((VisualElement)this.subject);
    }

    @Override
    public OverlapsAssert<T> about(DirectionalDistanceConstraint constraint) {
        this.overlapConstraints.add(constraint.withPrecision(this.precision));
        return this;
    }

    @Override
    public OverlapsAssert<T> withPrecision(Precision precision) {
        if (this.overlapConstraints.isEmpty()) {
            this.precision = precision;
        } else {
            int index = this.overlapConstraints.size() - 1;
            this.overlapConstraints.set(index, this.overlapConstraints.get(index).withPrecision(precision));
        }
        return this;
    }
}

