/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.allotropy.fluent.directional.DirectionalDistanceConstraint;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.directions.Directed;
import net.amygdalum.allotropy.fluent.distances.PixelDistance;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.elements.VisualOperand;
import net.amygdalum.allotropy.fluent.precision.Precision;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.single.InsideAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;

public class DefaultInsideAssert<T extends VisualElement>
implements InsideAssert<T> {
    private T subject;
    private List<DirectionalDistanceConstraint> insideConstraints;
    private Precision precision;

    public DefaultInsideAssert(T subject) {
        this.subject = subject;
        this.insideConstraints = new ArrayList<DirectionalDistanceConstraint>();
        this.precision = Precision.exact();
    }

    @Override
    public AndAssert<T> ofElement(VisualElement object) {
        VisualOperand o;
        VisualOperand s = VisualOperand.op(this.subject);
        if (s.around(o = VisualOperand.op(object))) {
            throw AssertionErrors.expected(this.subject).insideOf(object).butWas("containing").asAssertionError();
        }
        if (s.outside(o)) {
            throw AssertionErrors.expected(this.subject).insideOf(object).butWas("outside").asAssertionError();
        }
        if (s.overlapping(o)) {
            throw AssertionErrors.expected(this.subject).insideOf(object).butWas("overlapping").asAssertionError();
        }
        List<Directed<PixelDistance>> distances = List.of(Directed.at(CardinalDirection.N).distance(new PixelDistance(s.topDistance(o))), Directed.at(CardinalDirection.E).distance(new PixelDistance(s.rightDistance(o))), Directed.at(CardinalDirection.S).distance(new PixelDistance(s.bottomDistance(o))), Directed.at(CardinalDirection.W).distance(new PixelDistance(s.leftDistance(o))));
        List<Directed> violatedConstraints = distances.stream().filter(d -> this.insideConstraints.stream().filter(c -> c.test(d.direction())).findFirst().map(c -> !c.test(d.subject())).orElse(false)).toList();
        if (!violatedConstraints.isEmpty()) {
            throw AssertionErrors.expected(this.subject).insideOf(object).with("distance").__(this.insideConstraints.stream().map(d -> d.description()).collect(Collectors.joining(", "))).butWas(violatedConstraints.stream().map(d -> d.subject() + " " + d.direction().label()).collect(Collectors.joining(", "))).asAssertionError();
        }
        return new DefaultAndAssert<T>(this.subject);
    }

    @Override
    public InsideAssert<T> about(DirectionalDistanceConstraint constraint) {
        this.insideConstraints.add(constraint.withPrecision(this.precision));
        return this;
    }

    @Override
    public InsideAssert<T> withPrecision(Precision precision) {
        if (this.insideConstraints.isEmpty()) {
            this.precision = precision;
        } else {
            int index = this.insideConstraints.size() - 1;
            this.insideConstraints.set(index, this.insideConstraints.get(index).withPrecision(precision));
        }
        return this;
    }
}

