/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.distances.AsPercentOf;
import net.amygdalum.allotropy.fluent.distances.AsPixels;
import net.amygdalum.allotropy.fluent.distances.Distance;
import net.amygdalum.allotropy.fluent.distances.DistanceConstraint;
import net.amygdalum.allotropy.fluent.distances.DistanceConstraintBuilder;
import net.amygdalum.allotropy.fluent.distances.PixelDistance;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.precision.Precision;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.single.DimensionConstrainingAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;

public class DefaultDimensionConstrainingAssert<T extends VisualElement>
implements DimensionConstrainingAssert<T> {
    private T subject;
    private Dimension dimension;
    private Precision precision;
    private DistanceConstraintBuilder builder;

    public DefaultDimensionConstrainingAssert(T subject, Dimension dimension, Precision precision, DistanceConstraintBuilder builder) {
        this.subject = subject;
        this.dimension = dimension;
        this.precision = precision;
        this.builder = builder;
    }

    @Override
    public AndAssert<T> pixels() {
        Distance dist = this.distance();
        DistanceConstraint distanceConstraint = this.builder.addResolver(new AsPixels()).build();
        this.check(distanceConstraint, dist);
        return new DefaultAndAssert<T>(this.subject);
    }

    @Override
    public AndAssert<T> percentOf(VisualElement element, Dimension dimension) {
        Distance dist = this.distance();
        DistanceConstraint distanceConstraint = this.builder.addResolver(new AsPercentOf(dimension, element.bounds())).build();
        this.check(distanceConstraint, dist);
        return new DefaultAndAssert<T>(this.subject);
    }

    @Override
    public AndAssert<T> percentOf(VisualElement element) {
        return this.percentOf(element, this.dimension);
    }

    @Override
    public AndAssert<T> percentOf(Dimension dimension) {
        return this.percentOf((VisualElement)this.subject, dimension);
    }

    private Distance distance() {
        return new PixelDistance(this.subject.bounds().size(this.dimension));
    }

    private void check(DistanceConstraint distanceConstraint, Distance dist) {
        if (!((DistanceConstraint)distanceConstraint.withPrecision(this.precision)).test(dist)) {
            throw AssertionErrors.expected(this.subject).toHave(this.dimension.dimensionLabel()).__(distanceConstraint.description()).butFound(dist).asAssertionError();
        }
    }
}

