/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.allotropy.fluent.directional.DirectionalDistanceConstraint;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.directions.Directed;
import net.amygdalum.allotropy.fluent.distances.PixelDistance;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.elements.VisualOperand;
import net.amygdalum.allotropy.fluent.precision.Precision;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.ContainsAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;

public class DefaultContainsAssert<T extends VisualElement>
implements ContainsAssert<T> {
    private T subject;
    private List<DirectionalDistanceConstraint> insideConstraints;
    private Precision precision;

    public DefaultContainsAssert(T subject) {
        this.subject = subject;
        this.insideConstraints = new ArrayList<DirectionalDistanceConstraint>();
        this.precision = Precision.exact();
    }

    @Override
    public AndAssert<T> itemElements(VisualElement ... items) {
        VisualOperand s = VisualOperand.op(this.subject);
        for (VisualElement object : items) {
            VisualOperand o = VisualOperand.op(object);
            if (s.inside(o)) {
                throw AssertionErrors.expected(this.subject).containing(object).butWas("contained").asAssertionError();
            }
            if (s.overlapping(o)) {
                throw AssertionErrors.expected(this.subject).containing(object).butWas("overlapping").asAssertionError();
            }
            if (s.outside(o)) {
                throw AssertionErrors.expected(this.subject).containing(object).butWas("outside").asAssertionError();
            }
            List<Directed<PixelDistance>> distances = List.of(Directed.at(CardinalDirection.N).distance(new PixelDistance(o.topDistance(s))), Directed.at(CardinalDirection.E).distance(new PixelDistance(o.rightDistance(s))), Directed.at(CardinalDirection.S).distance(new PixelDistance(o.bottomDistance(s))), Directed.at(CardinalDirection.W).distance(new PixelDistance(o.leftDistance(s))));
            List<Directed> violatedConstraints = distances.stream().filter(d -> this.insideConstraints.stream().filter(c -> c.test(d.direction())).findFirst().map(c -> !c.test(d.subject())).orElse(false)).toList();
            if (violatedConstraints.isEmpty()) continue;
            throw AssertionErrors.expected(this.subject).containing(object).with("distance").__(this.insideConstraints.stream().map(d -> d.description()).collect(Collectors.joining(", "))).butWas(violatedConstraints.stream().map(d -> d.subject() + " " + d.direction().label()).collect(Collectors.joining(", "))).asAssertionError();
        }
        return new DefaultAndAssert<T>(this.subject);
    }

    @Override
    public ContainsAssert<T> about(DirectionalDistanceConstraint constraint) {
        this.insideConstraints.add(constraint.withPrecision(this.precision));
        return this;
    }

    @Override
    public ContainsAssert<T> withPrecision(Precision precision) {
        if (this.insideConstraints.isEmpty()) {
            this.precision = precision;
        } else {
            int index = this.insideConstraints.size() - 1;
            this.insideConstraints.set(index, this.insideConstraints.get(index).withPrecision(precision));
        }
        return this;
    }
}

