/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import java.util.stream.Collectors;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.distances.Distance;
import net.amygdalum.allotropy.fluent.distances.DistanceConstraint;
import net.amygdalum.allotropy.fluent.distances.DistanceResolver;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.precision.Precision;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.AtAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;

public class DefaultAtAssert<T extends VisualElement>
implements AtAssert<T> {
    private T subject;
    private DistanceConstraint distanceConstraint;
    private DistanceResolver distanceResolver;
    private Precision precision;

    public DefaultAtAssert(T subject) {
        this.subject = subject;
        this.distanceConstraint = DistanceConstraint.NONE;
        this.distanceResolver = DistanceResolver.DEFAULT;
        this.precision = Precision.exact();
    }

    @Override
    public AndAssert<T> ofElement(VisualElement object) {
        Distance dist = this.distanceResolver.resolveDistance((VisualElement)this.subject, object).orElseThrow(() -> AssertionErrors.expected(this.subject).and(object).toBe(this.distanceResolver.description()).butWere("overlapping or skew").asAssertionError());
        if (!this.distanceConstraint.test(dist)) {
            throw AssertionErrors.expected(this.subject).toHave("distance").__(this.distanceConstraint.description()).to(object).at(this.distanceResolver.directions().stream().map(d -> d.label()).collect(Collectors.joining(", "))).butFound(dist).asAssertionError();
        }
        return new DefaultAndAssert<T>(this.subject);
    }

    @Override
    public AtAssert<T> to(CardinalDirection direction) {
        if (!this.narrowableTo(direction)) {
            throw new IllegalArgumentException("cannot combine " + this.distanceResolver.description() + " with direction " + direction.label());
        }
        this.distanceResolver = new DistanceResolver(direction);
        return this;
    }

    private boolean narrowableTo(CardinalDirection direction) {
        return this.distanceResolver.directions().contains(direction);
    }

    @Override
    public AtAssert<T> about(DistanceConstraint distanceConstraint) {
        this.distanceConstraint = (DistanceConstraint)distanceConstraint.withPrecision(this.precision);
        return this;
    }

    @Override
    public AtAssert<T> withPrecision(Precision precision) {
        if (this.distanceConstraint == DistanceConstraint.NONE) {
            this.precision = precision;
        } else {
            this.distanceConstraint = (DistanceConstraint)this.distanceConstraint.withPrecision(precision);
        }
        return this;
    }
}

