/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.single;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.amygdalum.allotropy.fluent.alignment.Alignment;
import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.elements.BoolWithExplanation;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.elements.VisualOperand;
import net.amygdalum.allotropy.fluent.precision.Precision;
import net.amygdalum.allotropy.fluent.single.AlignedAssert;
import net.amygdalum.allotropy.fluent.single.AndAssert;
import net.amygdalum.allotropy.fluent.single.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;
import net.amygdalum.allotropy.fluent.utils.Exceptions;

public class DefaultAlignedAssert<T extends VisualElement>
implements AlignedAssert<T> {
    private T subject;
    private Dimension dimension;
    private Set<Alignment> alignments;
    private Precision precision;

    public DefaultAlignedAssert(T subject, Dimension dimension) {
        this.subject = subject;
        this.dimension = dimension;
        this.alignments = new HashSet<Alignment>();
        this.precision = Precision.exact();
    }

    @Override
    public AndAssert<T> withElement(VisualElement object) {
        VisualOperand s = VisualOperand.op(this.subject).withPrecision(this.precision);
        VisualOperand o = VisualOperand.op(object).withPrecision(this.precision);
        if (this.dimension == Dimension.HORIZONTAL) {
            var5_4 = s.nextTo(o);
            if (var5_4 instanceof BoolWithExplanation.FalseWithExplanation) {
                BoolWithExplanation.FalseWithExplanation e = (BoolWithExplanation.FalseWithExplanation)var5_4;
                throw AssertionErrors.expected(this.subject).aligned(this.dimension.adLabel()).with(object).butWas(e.explanation()).asAssertionError();
            }
        } else if (this.dimension == Dimension.VERTICAL) {
            var5_4 = s.stacked(o);
            if (var5_4 instanceof BoolWithExplanation.FalseWithExplanation) {
                BoolWithExplanation.FalseWithExplanation e = (BoolWithExplanation.FalseWithExplanation)var5_4;
                throw AssertionErrors.expected(this.subject).aligned(this.dimension.adLabel()).with(object).butWas(e.explanation()).asAssertionError();
            }
        } else {
            throw Exceptions.defaultInExhaustiveMatch();
        }
        for (Alignment alignment : this.alignments) {
            double ocoord;
            double scoord = s.at(alignment);
            if (this.precision.eq(scoord, ocoord = o.at(alignment))) continue;
            throw AssertionErrors.expected(this.subject).aligned(this.dimension.adLabel()).__(alignment.label()).with(object).butNot(alignment.label()).asAssertionError();
        }
        return new DefaultAndAssert<T>(this.subject);
    }

    @Override
    public AlignedAssert<T> withPrecision(Precision precision) {
        this.precision = precision;
        return this;
    }

    @Override
    public AlignedAssert<T> all() {
        Stream.of(CardinalDirection.N, CardinalDirection.S, CardinalDirection.W, CardinalDirection.E).filter(direction -> this.matches(Alignment.to(direction))).forEach(this::alignedTo);
        return this;
    }

    @Override
    public AlignedAssert<T> centered() {
        Stream.of(Dimension.HORIZONTAL, Dimension.VERTICAL).map(dimension -> Alignment.centered(dimension)).filter(centered -> this.matches((Alignment)centered)).forEach(this::alignedTo);
        return this;
    }

    @Override
    public AlignedAssert<T> alignedTo(Alignment alignment) {
        if (!this.matches(alignment)) {
            throw new IllegalArgumentException("cannot align " + this.dimension.adLabel() + " " + alignment.label());
        }
        this.alignments.add(alignment);
        return this;
    }

    private boolean matches(Alignment alignment) {
        return alignment.dimension() != this.dimension;
    }
}

