/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.multiple;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.amygdalum.allotropy.fluent.Expectations;
import net.amygdalum.allotropy.fluent.common.Constraint;
import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.multiple.AlignedAssert;
import net.amygdalum.allotropy.fluent.multiple.AndAssert;
import net.amygdalum.allotropy.fluent.multiple.CountAssert;
import net.amygdalum.allotropy.fluent.multiple.DefaultAlignedAssert;
import net.amygdalum.allotropy.fluent.multiple.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.multiple.DefaultCountAssert;
import net.amygdalum.allotropy.fluent.multiple.VisualElementsAssert;
import net.amygdalum.allotropy.fluent.single.VisualElementAssert;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;

public class DefaultVisualElementsAssert<T extends VisualElement>
implements VisualElementsAssert<T> {
    private T[] subjects;

    public DefaultVisualElementsAssert(T[] subjects) {
        this.subjects = subjects;
    }

    @Override
    public AlignedAssert<T> alignedVertically() {
        return new DefaultAlignedAssert(this.subjects, Dimension.VERTICAL);
    }

    @Override
    public AlignedAssert<T> alignedHorizontally() {
        return new DefaultAlignedAssert(this.subjects, Dimension.HORIZONTAL);
    }

    @Override
    public AndAssert<T> property(Constraint<VisualElement> condition) {
        for (T subject : this.subjects) {
            if (condition.test((VisualElement)subject)) continue;
            throw AssertionErrors.expected(subject).toBe(condition.description()).butWas("not").asAssertionError();
        }
        return new DefaultAndAssert(this.subjects);
    }

    @Override
    public AndAssert<T> each(Consumer<VisualElementAssert<T>> elementAssert) {
        for (T subject : this.subjects) {
            elementAssert.accept(Expectations.expectElement(subject));
        }
        return new DefaultAndAssert(this.subjects);
    }

    @Override
    public <S extends VisualElement> AndAssert<T> chunked(Function<T[], S[][]> selector, Consumer<VisualElementsAssert<S>> chunkAssert) {
        VisualElement[][] chunked;
        for (VisualElement[] chunk : chunked = (VisualElement[][])selector.apply(this.subjects)) {
            chunkAssert.accept(Expectations.expectElements((VisualElement[])chunk));
        }
        return new DefaultAndAssert(this.subjects);
    }

    @Override
    public VisualElementsAssert<T> sorted(Comparator<T> comparator) {
        VisualElement[] sortedSubjects = (VisualElement[])Arrays.copyOf(this.subjects, this.subjects.length);
        Arrays.sort(sortedSubjects, comparator);
        return new DefaultVisualElementsAssert(sortedSubjects);
    }

    @Override
    public <S extends VisualElement> AndAssert<T> select(Function<T, S> selector, Consumer<VisualElementsAssert<S>> selectedAssert) {
        VisualElement[] selected = (VisualElement[])Arrays.stream(this.subjects).map(s -> (VisualElement)selector.apply(s)).collect(net.amygdalum.allotropy.fluent.utils.Arrays.toArray());
        selectedAssert.accept(new DefaultVisualElementsAssert(selected));
        return new DefaultAndAssert(this.subjects);
    }

    @Override
    public CountAssert<T> count() {
        return new DefaultCountAssert(this.subjects);
    }
}

