/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.multiple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.allotropy.fluent.alignment.Alignment;
import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.distances.PixelDistance;
import net.amygdalum.allotropy.fluent.elements.BoolWithExplanation;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.elements.VisualOperand;
import net.amygdalum.allotropy.fluent.multiple.AlignedAssert;
import net.amygdalum.allotropy.fluent.multiple.AndAssert;
import net.amygdalum.allotropy.fluent.multiple.DefaultAndAssert;
import net.amygdalum.allotropy.fluent.precision.Precision;
import net.amygdalum.allotropy.fluent.utils.AssertionErrors;
import net.amygdalum.allotropy.fluent.utils.Exceptions;

public class DefaultAlignedAssert<T extends VisualElement>
implements AlignedAssert<T> {
    private T[] subjects;
    private Dimension dimension;
    private Set<Alignment> alignments;
    private boolean equalDistanced;
    private Precision precision;

    public DefaultAlignedAssert(T[] subjects, Dimension dimension) {
        this.subjects = subjects;
        this.dimension = dimension;
        this.alignments = new HashSet<Alignment>();
        this.equalDistanced = false;
        this.precision = Precision.exact();
    }

    @Override
    public AndAssert<T> withEachOther() {
        for (Combination<T> combination : this.combinations()) {
            VisualOperand subject = VisualOperand.op((VisualElement)combination.subject).withPrecision(this.precision);
            VisualOperand object = VisualOperand.op((VisualElement)combination.object).withPrecision(this.precision);
            if (this.dimension == Dimension.HORIZONTAL) {
                var6_8 = subject.nextTo(object);
                if (var6_8 instanceof BoolWithExplanation.FalseWithExplanation) {
                    e = (BoolWithExplanation.FalseWithExplanation)var6_8;
                    throw AssertionErrors.expected(combination.subject).aligned(this.dimension.adLabel()).with(combination.object).butWas(((BoolWithExplanation.FalseWithExplanation)e).explanation()).asAssertionError();
                }
            } else if (this.dimension == Dimension.VERTICAL) {
                var6_8 = subject.stacked(object);
                if (var6_8 instanceof BoolWithExplanation.FalseWithExplanation) {
                    e = (BoolWithExplanation.FalseWithExplanation)var6_8;
                    throw AssertionErrors.expected(combination.subject).aligned(this.dimension.adLabel()).with(combination.object).butWas(((BoolWithExplanation.FalseWithExplanation)e).explanation()).asAssertionError();
                }
            } else {
                throw Exceptions.defaultInExhaustiveMatch();
            }
            for (Alignment alignment : this.alignments) {
                double ocoord;
                double scoord = subject.at(alignment);
                if (this.precision.eq(scoord, ocoord = object.at(alignment))) continue;
                throw AssertionErrors.expected(combination.subject).aligned(this.dimension.adLabel()).__(alignment.label()).with(combination.object).butNot(alignment.label()).asAssertionError();
            }
        }
        if (this.equalDistanced) {
            BiFunction<VisualOperand, VisualOperand, Double> distance = this.dimension == Dimension.VERTICAL ? (s, o) -> s.bottomDistanceToTop((VisualOperand)o) : (s, o) -> s.rightDistanceToLeft((VisualOperand)o);
            Set distances = this.neighbours().stream().map(n -> (Double)distance.apply(VisualOperand.op((VisualElement)n.subject), VisualOperand.op((VisualElement)n.object))).collect(Collectors.toSet());
            double min = distances.stream().min(Double::compare).orElse(0.0);
            double max = distances.stream().max(Double::compare).orElse(0.0);
            if (!this.precision.eq(max, min)) {
                throw AssertionErrors.expectedAllOf(this.subjects).aligned(this.dimension.adLabel()).with("each other").__("equally distanced").butFound("between").__(new PixelDistance(min)).and(new PixelDistance(max)).asAssertionError();
            }
        }
        return new DefaultAndAssert(this.subjects);
    }

    @Override
    public AlignedAssert<T> withPrecision(Precision precision) {
        this.precision = precision;
        return this;
    }

    @Override
    public AlignedAssert<T> all() {
        Stream.of(CardinalDirection.N, CardinalDirection.S, CardinalDirection.W, CardinalDirection.E).filter(direction -> this.matches(Alignment.to(direction))).forEach(this::alignedTo);
        return this;
    }

    @Override
    public AlignedAssert<T> centered() {
        Stream.of(Dimension.HORIZONTAL, Dimension.VERTICAL).map(dimension -> Alignment.centered(dimension)).filter(centered -> this.matches((Alignment)centered)).forEach(this::alignedTo);
        return this;
    }

    @Override
    public AlignedAssert<T> alignedTo(Alignment alignment) {
        if (!this.matches(alignment)) {
            throw new IllegalArgumentException("cannot align " + this.dimension.adLabel() + " " + alignment.label());
        }
        this.alignments.add(alignment);
        return this;
    }

    @Override
    public AlignedAssert<T> equallyDistanced() {
        this.equalDistanced = true;
        return this;
    }

    private boolean matches(Alignment alignment) {
        return alignment.dimension() != this.dimension;
    }

    private List<Combination<T>> combinations() {
        ArrayList<Combination<T>> combinations = new ArrayList<Combination<T>>();
        for (int i = 0; i < this.subjects.length; ++i) {
            for (int j = i + 1; j < this.subjects.length; ++j) {
                combinations.add(new Combination<T>(this.subjects[i], this.subjects[j]));
            }
        }
        return combinations;
    }

    private List<Combination<T>> neighbours() {
        ArrayList<Combination<T>> combinations = new ArrayList<Combination<T>>();
        for (int i = 0; i < this.subjects.length - 1; ++i) {
            combinations.add(new Combination<T>(this.subjects[i], this.subjects[i + 1]));
        }
        return combinations;
    }

    private record Combination<T>(T subject, T object) {
    }
}

