/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.javascript;

import net.amygdalum.allotropy.fluent.elements.Bounds;
import net.amygdalum.allotropy.fluent.javascript.CSSStyleDeclaration;
import net.amygdalum.allotropy.fluent.javascript.Value;
import net.amygdalum.allotropy.fluent.utils.InterfaceResolver;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class HtmlElement {
    private JavascriptExecutor js;
    private WebElement element;

    private HtmlElement(JavascriptExecutor js, WebElement element) {
        this.js = js;
        this.element = element;
    }

    public static HtmlElement from(WebElement element) {
        return HtmlElement.from(InterfaceResolver.webDriverFrom(element), element);
    }

    public static HtmlElement from(WebDriver webDriver, WebElement element) {
        return HtmlElement.from(InterfaceResolver.javascriptExecutorFrom(webDriver), element);
    }

    public static HtmlElement from(JavascriptExecutor javascriptExecutor, WebElement element) {
        return new HtmlElement(javascriptExecutor, element);
    }

    public Bounds getBoundingClientRect() {
        return Bounds.from(this.js.executeScript("return arguments[0].getBoundingClientRect();", new Object[]{this.element}));
    }

    public CSSStyleDeclaration getComputedStyle() {
        return CSSStyleDeclaration.from(new Value("computedStyle", "window.getComputedStyle(arguments[0])", this.element), this.js);
    }
}

