/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.elements;

import java.util.List;
import java.util.Optional;
import net.amygdalum.allotropy.fluent.elements.AsVisualElement;
import net.amygdalum.allotropy.fluent.elements.Bounds;
import net.amygdalum.allotropy.fluent.elements.DisplayableElement;
import net.amygdalum.allotropy.fluent.elements.Layer;
import net.amygdalum.allotropy.fluent.elements.LayerableElement;
import net.amygdalum.allotropy.fluent.elements.StyleableElement;
import net.amygdalum.allotropy.fluent.elements.TextContainingElement;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.elements.WebElementLayer;
import net.amygdalum.allotropy.fluent.javascript.HtmlElement;
import net.amygdalum.allotropy.fluent.utils.InterfaceResolver;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;

public class WebVisualElement
implements VisualElement,
AsVisualElement<WebVisualElement>,
TextContainingElement,
StyleableElement,
LayerableElement,
DisplayableElement,
WrapsElement,
WrapsDriver {
    private WebDriver webDriver;
    private WebElement element;

    public WebVisualElement(WebElement element) {
        this.webDriver = InterfaceResolver.webDriverFrom(element);
        this.element = element;
    }

    public WebVisualElement(WebDriver webDriver, WebElement element) {
        this.webDriver = webDriver;
        this.element = element;
    }

    @Override
    public Bounds bounds() {
        return HtmlElement.from(this.webDriver, this.element).getBoundingClientRect();
    }

    @Override
    public Optional<VisualElement> parent() {
        return Optional.ofNullable(this.element.findElement(By.xpath((String)"./.."))).map(e -> new WebVisualElement(this.webDriver, (WebElement)e));
    }

    @Override
    public WebVisualElement asVisualElement() {
        return this;
    }

    public List<WebVisualElement> findElements(By by) {
        return this.element.findElements(by).stream().map(e -> new WebVisualElement(this.webDriver, (WebElement)e)).toList();
    }

    public WebVisualElement findElement(By by) {
        return new WebVisualElement(this.webDriver, this.element.findElement(by));
    }

    @Override
    public String text() {
        return this.element.getText();
    }

    @Override
    public String style(String attribute) {
        return HtmlElement.from(this.webDriver, this.element).getComputedStyle().forAttribute(attribute);
    }

    @Override
    public Layer layer() {
        return new WebElementLayer(this.webDriver, this.element);
    }

    @Override
    public boolean isDisplayed() {
        return this.element.isDisplayed();
    }

    public WebDriver getWrappedDriver() {
        return this.webDriver;
    }

    public WebElement getWrappedElement() {
        return this.element;
    }

    public String toString() {
        String s = this.element.toString();
        return s.replaceAll("\\[[^\\[].+?\\]", "[]");
    }
}

