/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.elements;

import net.amygdalum.allotropy.fluent.alignment.Alignment;
import net.amygdalum.allotropy.fluent.elements.BoolWithExplanation;
import net.amygdalum.allotropy.fluent.elements.Bounds;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.precision.Precisable;
import net.amygdalum.allotropy.fluent.precision.Precision;
import net.amygdalum.allotropy.fluent.utils.Exceptions;

public record VisualOperand(Precision precision, Bounds bounds) implements Precisable<VisualOperand>
{
    public static VisualOperand op(VisualElement element) {
        return new VisualOperand(Precision.exact(), element.bounds());
    }

    @Override
    public VisualOperand withPrecision(Precision precision) {
        return new VisualOperand(precision, this.bounds);
    }

    public BoolWithExplanation nextTo(VisualOperand that) {
        if (!this.precision.lt(this.leftDistance(that), 0.0) && !this.precision.lt(this.rightDistance(that), 0.0)) {
            if (this.topDistance(that) >= 0.0 && this.bottomDistance(that) >= 0.0) {
                return BoolWithExplanation.fail("inside");
            }
            if (this.topDistanceToBottom(that) * this.bottomDistanceToTop(that) >= 0.0) {
                return BoolWithExplanation.fail("overlapping vertically");
            }
            return BoolWithExplanation.fail("stacked");
        }
        if (!this.precision.ge(this.leftDistanceToRight(that), 0.0) && !this.precision.ge(this.rightDistanceToLeft(that), 0.0)) {
            return BoolWithExplanation.fail("displaced");
        }
        if (!this.precision.ge(this.topDistance(that), 0.0) && !this.precision.le(this.bottomDistance(that), 0.0) || !this.precision.le(this.topDistance(that), 0.0) && !this.precision.ge(this.bottomDistance(that), 0.0)) {
            return BoolWithExplanation.fail("displaced");
        }
        return BoolWithExplanation.TRUE;
    }

    public BoolWithExplanation stacked(VisualOperand that) {
        if (!this.precision.lt(this.topDistance(that), 0.0) && !this.precision.lt(this.bottomDistance(that), 0.0)) {
            if (this.leftDistance(that) >= 0.0 && this.rightDistance(that) >= 0.0) {
                return BoolWithExplanation.fail("inside");
            }
            if (this.leftDistanceToRight(that) * this.rightDistanceToLeft(that) >= 0.0) {
                return BoolWithExplanation.fail("overlapping horizontally");
            }
            return BoolWithExplanation.fail("next to");
        }
        if (!this.precision.ge(this.topDistanceToBottom(that), 0.0) && !this.precision.ge(this.bottomDistanceToTop(that), 0.0)) {
            return BoolWithExplanation.fail("displaced");
        }
        if (!this.precision.ge(this.leftDistance(that), 0.0) && !this.precision.le(this.rightDistance(that), 0.0) || !this.precision.le(this.leftDistance(that), 0.0) && !this.precision.ge(this.rightDistance(that), 0.0)) {
            return BoolWithExplanation.fail("displaced");
        }
        return BoolWithExplanation.TRUE;
    }

    public boolean around(VisualOperand that) {
        return this.topDistance(that) <= 0.0 && this.rightDistance(that) <= 0.0 && this.bottomDistance(that) <= 0.0 && this.leftDistance(that) <= 0.0;
    }

    public boolean inside(VisualOperand that) {
        return this.topDistance(that) >= 0.0 && this.rightDistance(that) >= 0.0 && this.bottomDistance(that) >= 0.0 && this.leftDistance(that) >= 0.0;
    }

    public boolean outside(VisualOperand that) {
        return this.topDistanceToBottom(that) > 0.0 || this.bottomDistanceToTop(that) > 0.0 || this.leftDistanceToRight(that) > 0.0 || this.rightDistanceToLeft(that) > 0.0;
    }

    public boolean overlapping(VisualOperand that) {
        return this.topDistanceToBottom(that) <= 0.0 && this.bottomDistanceToTop(that) <= 0.0 && this.leftDistanceToRight(that) <= 0.0 && this.rightDistanceToLeft(that) <= 0.0 && (this.topDistance(that) < 0.0 || this.rightDistance(that) < 0.0 || this.bottomDistance(that) < 0.0 || this.leftDistance(that) < 0.0) && (this.topDistance(that) > 0.0 || this.rightDistance(that) > 0.0 || this.bottomDistance(that) > 0.0 || this.leftDistance(that) > 0.0);
    }

    public double topDistance(VisualOperand that) {
        return this.bounds.top() - that.bounds.top();
    }

    public double rightDistance(VisualOperand that) {
        return that.bounds().right() - this.bounds().right();
    }

    public double bottomDistance(VisualOperand that) {
        return that.bounds().bottom() - this.bounds().bottom();
    }

    public double leftDistance(VisualOperand that) {
        return this.bounds().left() - that.bounds().left();
    }

    public double topDistanceToBottom(VisualOperand that) {
        return this.bounds.top() - that.bounds.bottom() - 1;
    }

    public double rightDistanceToLeft(VisualOperand that) {
        return that.bounds().left() - this.bounds().right() - 1;
    }

    public double bottomDistanceToTop(VisualOperand that) {
        return that.bounds().top() - this.bounds().bottom() - 1;
    }

    public double leftDistanceToRight(VisualOperand that) {
        return this.bounds().left() - that.bounds().right() - 1;
    }

    public double at(Alignment alignment) {
        if (alignment instanceof Alignment.Boundary) {
            Alignment.Boundary boundary = (Alignment.Boundary)alignment;
            return this.bounds.bound(boundary.direction());
        }
        if (alignment instanceof Alignment.Center) {
            Alignment.Center center = (Alignment.Center)alignment;
            return this.bounds.center(center.dimension());
        }
        throw Exceptions.defaultInExhaustiveMatch();
    }
}

