/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.elements;

import java.util.Map;
import java.util.Optional;
import net.amygdalum.allotropy.fluent.elements.Bounds;
import net.amygdalum.allotropy.fluent.elements.VisualElement;

public record Viewport(int width, int height) implements VisualElement
{
    public static Viewport from(Object object) {
        if (object instanceof Viewport) {
            Viewport viewport = (Viewport)object;
            return viewport;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            try {
                int width = Float.valueOf(map.get("width").toString()).intValue();
                int height = Float.valueOf(map.get("height").toString()).intValue();
                return new Viewport(width, height);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Bounds bounds() {
        return new Bounds(0, 0, this.width, this.height);
    }

    @Override
    public Optional<VisualElement> parent() {
        return Optional.empty();
    }
}

