/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.elements;

import java.util.Map;
import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.elements.Point;

public record Bounds(int left, int top, int right, int bottom) {
    public static Bounds from(Object object) {
        if (object instanceof Bounds) {
            Bounds bounds = (Bounds)object;
            return bounds;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            try {
                int x = Float.valueOf(map.get("x").toString()).intValue();
                int y = Float.valueOf(map.get("y").toString()).intValue();
                int width = Float.valueOf(map.get("width").toString()).intValue();
                int height = Float.valueOf(map.get("height").toString()).intValue();
                return new Bounds(x, y, x + width - 1, y + height - 1);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public double bound(CardinalDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case CardinalDirection.N -> this.top();
            case CardinalDirection.E -> this.right();
            case CardinalDirection.S -> this.bottom();
            case CardinalDirection.W -> this.left();
        };
    }

    public double center(Dimension dimension) {
        return switch (dimension) {
            default -> throw new IncompatibleClassChangeError();
            case Dimension.HORIZONTAL -> (double)(this.left() + this.right()) / 2.0;
            case Dimension.VERTICAL -> (double)(this.top() + this.bottom()) / 2.0;
        };
    }

    public Point bottomLeft() {
        return new Point(this.left(), this.bottom());
    }

    public Point bottomRight() {
        return new Point(this.right(), this.bottom());
    }

    public Point topLeft() {
        return new Point(this.left(), this.top());
    }

    public Point topRight() {
        return new Point(this.right(), this.top());
    }

    public int width() {
        return this.right - this.left + 1;
    }

    public int height() {
        return this.bottom - this.top + 1;
    }

    public int size(Dimension dimension) {
        return switch (dimension) {
            default -> throw new IncompatibleClassChangeError();
            case Dimension.HORIZONTAL -> this.width();
            case Dimension.VERTICAL -> this.height();
        };
    }

    public boolean contains(Point p) {
        return this.top <= p.y() && this.bottom >= p.y() && this.left <= p.x() && this.right >= p.x();
    }

    @Override
    public String toString() {
        return "[" + this.left + ", " + this.top + "] => [" + this.right + ", " + this.bottom + "]";
    }
}

