/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.distances;

import java.text.NumberFormat;
import java.util.Locale;
import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.distances.Distance;
import net.amygdalum.allotropy.fluent.elements.Bounds;

public record PercentageDistance(double percent, Dimension dimension, Bounds bounds) implements Distance
{
    private static final NumberFormat FORMAT = PercentageDistance.numberFormat();

    private static NumberFormat numberFormat() {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat;
    }

    @Override
    public double pixels() {
        return this.percent / 100.0 * (double)this.bounds.size(this.dimension);
    }

    @Override
    public String toString() {
        return FORMAT.format(this.percent) + "% of the " + this.dimension.dimensionLabel() + " of " + this.bounds;
    }
}

