/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.distances;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.distances.Distance;
import net.amygdalum.allotropy.fluent.distances.PixelDistance;
import net.amygdalum.allotropy.fluent.elements.VisualElement;
import net.amygdalum.allotropy.fluent.elements.VisualOperand;

public record DistanceResolver(Set<CardinalDirection> directions) {
    public static final DistanceResolver DEFAULT = new DistanceResolver(CardinalDirection.N, CardinalDirection.E, CardinalDirection.S, CardinalDirection.W);

    public DistanceResolver(CardinalDirection ... directions) {
        this(Set.of(directions));
    }

    public Optional<Distance> resolveDistance(VisualElement subject, VisualElement object) {
        OptionalDouble minDistance;
        VisualOperand s = VisualOperand.op(subject);
        VisualOperand o = VisualOperand.op(object);
        DoubleStream.Builder builder = DoubleStream.builder();
        if (this.directions.contains(CardinalDirection.N)) {
            builder.accept(s.bottomDistanceToTop(o));
        }
        if (this.directions.contains(CardinalDirection.E)) {
            builder.accept(s.leftDistanceToRight(o));
        }
        if (this.directions.contains(CardinalDirection.S)) {
            builder.accept(s.topDistanceToBottom(o));
        }
        if (this.directions.contains(CardinalDirection.W)) {
            builder.accept(s.rightDistanceToLeft(o));
        }
        if ((minDistance = builder.build().filter(distance -> distance >= 0.0).min()).isPresent()) {
            return Optional.of(new PixelDistance(minDistance.orElse(0.0)));
        }
        return Optional.empty();
    }

    public String description() {
        if (this.directions.size() == CardinalDirection.values().length) {
            return "near";
        }
        return "at " + this.directions.stream().map(d -> d.label()).collect(Collectors.joining(" or "));
    }
}

