/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.distances;

import net.amygdalum.allotropy.fluent.distances.Distance;
import net.amygdalum.allotropy.fluent.distances.DistanceConstraint;
import net.amygdalum.allotropy.fluent.precision.Precision;

public record BetweenDistanceConstraint(Precision precision, Distance from, Distance to) implements DistanceConstraint
{
    public static BetweenDistanceConstraint between(Distance ... distances) {
        return new BetweenDistanceConstraint(Precision.exact(), distances[0], distances[1]);
    }

    @Override
    public boolean test(Distance dist) {
        return this.precision.le(this.from.pixels(), dist.pixels()) && this.precision.ge(this.to.pixels(), dist.pixels());
    }

    @Override
    public BetweenDistanceConstraint withPrecision(Precision precision) {
        return new BetweenDistanceConstraint(precision, this.from, this.to);
    }

    @Override
    public String description() {
        return "between " + this.from + " and " + this.to;
    }
}

