/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.directional;

import java.util.Optional;
import net.amygdalum.allotropy.fluent.common.Constraint;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;
import net.amygdalum.allotropy.fluent.distances.Distance;
import net.amygdalum.allotropy.fluent.distances.DistanceConstraint;
import net.amygdalum.allotropy.fluent.precision.Precisable;
import net.amygdalum.allotropy.fluent.precision.Precision;

public record DirectionalDistanceConstraint(Optional<CardinalDirection> direction, DistanceConstraint distance) implements Constraint<Object>,
Precisable<DirectionalDistanceConstraint>
{
    public static DirectionalDistanceConstraint NONE = new DirectionalDistanceConstraint(Optional.empty(), DistanceConstraint.NONE);

    @Override
    public boolean test(Object constrainable) {
        if (constrainable instanceof Distance) {
            Distance distance = (Distance)constrainable;
            return this.distance.test(distance);
        }
        if (constrainable instanceof CardinalDirection) {
            CardinalDirection direction = (CardinalDirection)constrainable;
            return this.direction.map(d -> d == direction).orElse(true);
        }
        throw new IllegalArgumentException("directional distance may not test on objects of type " + constrainable == null ? "null" : constrainable.getClass().getName());
    }

    @Override
    public DirectionalDistanceConstraint withPrecision(Precision precision) {
        return new DirectionalDistanceConstraint(this.direction, (DistanceConstraint)this.distance.withPrecision(precision));
    }

    @Override
    public String description() {
        return this.distance.description() + " " + this.direction.map(dx -> dx.label()).orElse("any");
    }
}

