/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.chunks;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import net.amygdalum.allotropy.fluent.elements.VisualElement;

public class Chunks {
    public static <T extends VisualElement> Function<T[], T[][]> window(int size) {
        return t -> {
            if (((VisualElement[])t).length < size) {
                return Chunks.newArray((VisualElement[])t, (int)0);
            }
            ArrayList<VisualElement[]> result = new ArrayList<VisualElement[]>();
            for (int i2 = 0; i2 <= ((VisualElement[])t).length - size; ++i2) {
                VisualElement[] window = Arrays.copyOfRange(t, i2, i2 + size);
                result.add(window);
            }
            return (VisualElement[][])result.toArray(i -> Chunks.newArray((VisualElement[])t, (int)i));
        };
    }

    public static <T extends VisualElement> Function<T[], T[][]> sized(int size) {
        return t -> {
            ArrayList<VisualElement[]> result = new ArrayList<VisualElement[]>();
            int start = 0;
            while (start < ((VisualElement[])t).length) {
                int end = ((VisualElement[])t).length <= start + size ? ((VisualElement[])t).length : start + size;
                VisualElement[] window = Arrays.copyOfRange(t, start, end);
                result.add(window);
                start = end;
            }
            return (VisualElement[][])result.toArray(i -> Chunks.newArray((VisualElement[])t, (int)i));
        };
    }

    public static <T extends VisualElement> T[][] newArray(T[] element, int i) {
        VisualElement[][] array = (VisualElement[][])Array.newInstance(element.getClass(), i);
        return array;
    }
}

