/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.allotropy.fluent.alignment;

import net.amygdalum.allotropy.fluent.dimensions.Dimension;
import net.amygdalum.allotropy.fluent.directions.CardinalDirection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Alignment {
    public String label();

    public Dimension dimension();

    public static Alignment to(CardinalDirection direction) {
        return Boundary.of(direction);
    }

    public static Alignment centered(Dimension dimension) {
        return Center.of(dimension);
    }

    public static enum Boundary implements Alignment
    {
        TOP(CardinalDirection.N, Dimension.VERTICAL),
        RIGHT(CardinalDirection.E, Dimension.HORIZONTAL),
        BOTTOM(CardinalDirection.S, Dimension.VERTICAL),
        LEFT(CardinalDirection.W, Dimension.HORIZONTAL);

        private CardinalDirection direction;
        private Dimension dimension;

        private Boundary(CardinalDirection direction, Dimension dimension) {
            this.direction = direction;
            this.dimension = dimension;
        }

        public static Boundary of(CardinalDirection direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case CardinalDirection.N -> TOP;
                case CardinalDirection.E -> RIGHT;
                case CardinalDirection.S -> BOTTOM;
                case CardinalDirection.W -> LEFT;
            };
        }

        @Override
        public String label() {
            return "at " + this.direction.label();
        }

        public CardinalDirection direction() {
            return this.direction;
        }

        @Override
        public Dimension dimension() {
            return this.dimension;
        }
    }

    public static enum Center implements Alignment
    {
        HORIZONTALLY(Dimension.HORIZONTAL),
        VERTICALLY(Dimension.VERTICAL);

        private Dimension dimension;

        private Center(Dimension dimension) {
            this.dimension = dimension;
        }

        public static Center of(Dimension dimension) {
            return switch (dimension) {
                default -> throw new IncompatibleClassChangeError();
                case Dimension.HORIZONTAL -> HORIZONTALLY;
                case Dimension.VERTICAL -> VERTICALLY;
            };
        }

        @Override
        public String label() {
            return "centered";
        }

        @Override
        public Dimension dimension() {
            return this.dimension;
        }
    }
}

