/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.worklist;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

public class WorkSet<T>
implements Queue<T> {
    private Set<T> done = new LinkedHashSet<T>();
    private Queue<T> elements;

    public WorkSet(Queue<T> base) {
        this.elements = base;
    }

    public WorkSet() {
        this(new LinkedList());
    }

    public Set<T> getDone() {
        return this.done;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.done.contains(o) || this.elements.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o) | this.done.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object element : c) {
            if (this.done.contains(element) || this.elements.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T element : c) {
            if (this.done.contains(element) || this.elements.contains(element)) continue;
            this.elements.add(element);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c) | this.done.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c) | this.done.retainAll(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.done.clear();
    }

    @Override
    public boolean add(T e) {
        if (this.done.contains(e) || this.elements.contains(e)) {
            return false;
        }
        this.elements.add(e);
        return true;
    }

    @Override
    public boolean offer(T e) {
        if (this.done.contains(e) || this.elements.contains(e)) {
            return false;
        }
        this.elements.add(e);
        return true;
    }

    @Override
    public T remove() {
        T head = this.elements.remove();
        this.done.add(head);
        return head;
    }

    @Override
    public T poll() {
        T head = this.elements.poll();
        if (head == null) {
            return null;
        }
        this.done.add(head);
        return head;
    }

    @Override
    public T element() {
        return this.elements.element();
    }

    @Override
    public T peek() {
        return this.elements.peek();
    }
}

