/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.tries;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.amygdalum.util.map.CharObjectMap;

public class PreCharTrieNode<T> {
    private CharObjectMap<PreCharTrieNode<T>> nextMap = new CharObjectMap<Object>(null);
    private PreCharTrieNode<T> link;
    private T attached;

    public void reset() {
        this.nextMap = new CharObjectMap<Object>(null);
    }

    public void addNext(char c, PreCharTrieNode<T> node) {
        this.nextMap.put(c, node);
    }

    public CharObjectMap<PreCharTrieNode<T>> getNexts() {
        return this.nextMap;
    }

    public void link(PreCharTrieNode<T> link) {
        this.link = link;
    }

    public PreCharTrieNode<T> getLink() {
        return this.link;
    }

    public T getAttached() {
        return this.attached;
    }

    public void setAttached(T attached) {
        this.attached = attached;
    }

    public PreCharTrieNode<T> extend(char[] chars, T attach) {
        PreCharTrieNode<T> node = this.extend(chars, 0);
        node.setAttached(attach);
        return node;
    }

    public PreCharTrieNode<T> extend(char[] chars, int i) {
        if (i >= chars.length) {
            return this;
        }
        PreCharTrieNode<T> toExtend = this.findNodeToExtend(chars[i]);
        return toExtend.extend(chars, i + 1);
    }

    private PreCharTrieNode<T> findNodeToExtend(char current) {
        PreCharTrieNode<T> node = this.nextNode(current);
        if (node == null) {
            node = new PreCharTrieNode<T>();
            this.addNext(current, node);
        }
        return node;
    }

    public PreCharTrieNode<T> nextNode(char c) {
        return this.nextMap.get(c);
    }

    public PreCharTrieNode<T> nextNode(char[] chars) {
        PreCharTrieNode<T> current = this;
        for (char c : chars) {
            if ((current = current.nextNode(c)) != null) continue;
            return null;
        }
        return current;
    }

    public Set<PreCharTrieNode<T>> nodes() {
        LinkedHashSet<PreCharTrieNode<T>> nodes = new LinkedHashSet<PreCharTrieNode<T>>();
        LinkedList<PreCharTrieNode> worklist = new LinkedList<PreCharTrieNode>();
        worklist.add(this);
        while (!worklist.isEmpty()) {
            PreCharTrieNode current = (PreCharTrieNode)worklist.remove();
            boolean added = nodes.add(current);
            if (!added) continue;
            for (CharObjectMap.Entry<PreCharTrieNode<T>> entry : current.getNexts().cursor()) {
                PreCharTrieNode node = (PreCharTrieNode)entry.value;
                worklist.add(node);
            }
        }
        return nodes;
    }

    public String toString() {
        if (this.attached != null) {
            return '[' + this.attached.toString() + ']';
        }
        return "[]";
    }
}

