/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.tries;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.amygdalum.util.map.ByteObjectMap;

public class PreByteTrieNode<T> {
    private ByteObjectMap<PreByteTrieNode<T>> nextMap = new ByteObjectMap<Object>(null);
    private PreByteTrieNode<T> link;
    private T attached;

    public void reset() {
        this.nextMap = new ByteObjectMap<Object>(null);
    }

    public void addNext(byte b, PreByteTrieNode<T> node) {
        this.nextMap.put(b, node);
    }

    public ByteObjectMap<PreByteTrieNode<T>> getNexts() {
        return this.nextMap;
    }

    public void link(PreByteTrieNode<T> link) {
        this.link = link;
    }

    public PreByteTrieNode<T> getLink() {
        return this.link;
    }

    public T getAttached() {
        return this.attached;
    }

    public void setAttached(T attached) {
        this.attached = attached;
    }

    public PreByteTrieNode<T> extend(byte[] bytes, T attach) {
        PreByteTrieNode<T> node = this.extend(bytes, 0);
        node.setAttached(attach);
        return node;
    }

    public PreByteTrieNode<T> extend(byte[] bytes, int i) {
        if (i >= bytes.length) {
            return this;
        }
        PreByteTrieNode<T> toExtend = this.findNodeToExtend(bytes[i]);
        return toExtend.extend(bytes, i + 1);
    }

    private PreByteTrieNode<T> findNodeToExtend(byte current) {
        PreByteTrieNode<T> node = this.nextNode(current);
        if (node == null) {
            node = new PreByteTrieNode<T>();
            this.addNext(current, node);
        }
        return node;
    }

    public PreByteTrieNode<T> nextNode(byte b) {
        return this.nextMap.get(b);
    }

    public PreByteTrieNode<T> nextNode(byte[] bytes) {
        PreByteTrieNode<T> current = this;
        for (byte b : bytes) {
            if ((current = current.nextNode(b)) != null) continue;
            return null;
        }
        return current;
    }

    public Set<PreByteTrieNode<T>> nodes() {
        LinkedHashSet<PreByteTrieNode<T>> nodes = new LinkedHashSet<PreByteTrieNode<T>>();
        LinkedList<PreByteTrieNode> worklist = new LinkedList<PreByteTrieNode>();
        worklist.add(this);
        while (!worklist.isEmpty()) {
            PreByteTrieNode current = (PreByteTrieNode)worklist.remove();
            boolean added = nodes.add(current);
            if (!added) continue;
            for (ByteObjectMap.Entry<PreByteTrieNode<T>> entry : current.getNexts().cursor()) {
                PreByteTrieNode node = (PreByteTrieNode)entry.value;
                worklist.add(node);
            }
        }
        return nodes;
    }

    public String toString() {
        if (this.attached != null) {
            return '[' + this.attached.toString() + ']';
        }
        return "[]";
    }
}

