/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.amygdalum.util.text.CharUtils;

public class StringSet {
    private Set<String>[] strings;
    private int[] lengths;

    public StringSet(List<char[]> chars) {
        this.lengths = CharUtils.lengths(chars);
        this.strings = StringSet.computeStrings(this.lengths, chars);
    }

    private static Set<String>[] computeStrings(int[] lengths, List<char[]> chars) {
        int max = lengths[0];
        int min = lengths[lengths.length - 1];
        Set[] strings = new Set[max - min + 1];
        for (int len : lengths) {
            strings[max - len] = new LinkedHashSet();
        }
        Object object = chars.iterator();
        while (object.hasNext()) {
            char[] pattern = (char[])object.next();
            int len = pattern.length;
            Set set = strings[max - len];
            set.add(new String(pattern));
        }
        return strings;
    }

    public int minLength() {
        return this.lengths[this.lengths.length - 1];
    }

    public int maxLength() {
        return this.lengths[0];
    }

    public int[] containedLengths() {
        return this.lengths;
    }

    public boolean contains(char[] pattern) {
        int len;
        int max = this.maxLength();
        Set<String> set = this.strings[max - (len = pattern.length)];
        if (set == null) {
            return false;
        }
        return set.contains(new String(pattern));
    }
}

