/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.util.ArrayList;
import net.amygdalum.util.text.CharMapping;
import net.amygdalum.util.text.MappingException;

public class QGramMapping {
    private int q;
    private int bits;
    private int mask;

    public QGramMapping(int q, int bits) {
        this.q = q;
        this.bits = bits;
        this.mask = QGramMapping.mask(bits);
    }

    private static int mask(int bits) {
        int mask = 0;
        for (int i = 0; i < bits; ++i) {
            mask = mask << 1 | 1;
        }
        return mask;
    }

    public char[] newQGram() {
        return new char[this.q];
    }

    public int getQ() {
        return this.q;
    }

    public int map(char[] chars) {
        if (this.q != chars.length) {
            throw new MappingException();
        }
        int code = 0;
        for (int i = 0; i < this.q; ++i) {
            char c = chars[i];
            code = code << this.bits | c & this.mask;
        }
        return code;
    }

    public int map(char[] chars, int pos) {
        if (pos + this.q > chars.length) {
            throw new MappingException();
        }
        int code = 0;
        for (int i = pos; i < pos + this.q; ++i) {
            char c = chars[i];
            code = code << this.bits | c & this.mask;
        }
        return code;
    }

    public int[] map(char[] chars, CharMapping mapping) {
        if (this.q != chars.length) {
            throw new MappingException();
        }
        ArrayList<Integer> codes = new ArrayList<Integer>(1);
        codes.add(0);
        for (int i = 0; i < this.q; ++i) {
            ArrayList<Integer> nextcodes = new ArrayList<Integer>();
            for (Integer code : codes) {
                for (char c : mapping.map(chars[i])) {
                    nextcodes.add(code << this.bits | c & this.mask);
                }
            }
            codes = nextcodes;
        }
        int[] flatcodes = new int[codes.size()];
        for (int i = 0; i < flatcodes.length; ++i) {
            flatcodes[i] = (Integer)codes.get(i);
        }
        return flatcodes;
    }

    public int[] map(char[] chars, int pos, CharMapping mapping) {
        if (pos + this.q > chars.length) {
            throw new MappingException();
        }
        ArrayList<Integer> codes = new ArrayList<Integer>(1);
        codes.add(0);
        for (int i = pos; i < pos + this.q; ++i) {
            ArrayList<Integer> nextcodes = new ArrayList<Integer>();
            for (Integer code : codes) {
                for (char c : mapping.map(chars[i])) {
                    nextcodes.add(code << this.bits | c & this.mask);
                }
            }
            codes = nextcodes;
        }
        int[] flatcodes = new int[codes.size()];
        for (int i = 0; i < flatcodes.length; ++i) {
            flatcodes[i] = (Integer)codes.get(i);
        }
        return flatcodes;
    }

    public int[] iterate(char[] chars) {
        if (chars.length < this.q) {
            throw new MappingException();
        }
        int[] qgrams = new int[chars.length - this.q + 1];
        for (int i = 0; i < qgrams.length; ++i) {
            qgrams[i] = this.map(chars, i);
        }
        return qgrams;
    }

    public int[][] iterate(char[] chars, CharMapping mapping) {
        if (chars.length < this.q) {
            throw new MappingException();
        }
        int[][] qgrams = new int[chars.length - this.q + 1][];
        for (int i = 0; i < qgrams.length; ++i) {
            qgrams[i] = this.map(chars, i, mapping);
        }
        return qgrams;
    }
}

