/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.util.List;
import net.amygdalum.util.builders.Lists;
import net.amygdalum.util.text.CharRange;

public class CharRangeAccumulator {
    private List<CharRange> ranges = Lists.of(new CharRange('\u0000', '\uffff'));

    public List<CharRange> getRanges() {
        return this.ranges;
    }

    public void split(char from, char to) {
        for (int i = 0; i < this.ranges.size(); ++i) {
            CharRange currentRange = this.ranges.get(i);
            if (currentRange.contains(from) && currentRange.contains(to)) {
                i = this.replace(i, currentRange.splitAround(from, to));
                continue;
            }
            if (currentRange.contains(from)) {
                i = this.replace(i, currentRange.splitBefore(from));
                continue;
            }
            if (!currentRange.contains(to)) continue;
            i = this.replace(i, currentRange.splitAfter(to));
        }
    }

    private int replace(int i, List<CharRange> replacement) {
        this.ranges.remove(i);
        this.ranges.addAll(i, replacement);
        return i + replacement.size() - 1;
    }
}

