/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.util.text.CharUtils;

public class CharRange {
    public char from;
    public char to;

    public CharRange(char from, char to) {
        this.from = from;
        this.to = to;
    }

    public boolean contains(char value) {
        return value >= this.from && value <= this.to;
    }

    public List<CharRange> splitBefore(char value) {
        if (value == this.from) {
            return Arrays.asList(this);
        }
        return Arrays.asList(new CharRange(this.from, CharUtils.before(value)), new CharRange(value, this.to));
    }

    public List<CharRange> splitAfter(char value) {
        if (value == this.to) {
            return Arrays.asList(this);
        }
        return Arrays.asList(new CharRange(this.from, value), new CharRange(CharUtils.after(value), this.to));
    }

    public List<CharRange> splitAround(char from, char to) {
        boolean toEnd;
        boolean fromStart = this.from == from;
        boolean bl = toEnd = this.to == to;
        if (fromStart && toEnd) {
            return Arrays.asList(this);
        }
        if (fromStart) {
            return Arrays.asList(new CharRange(from, to), new CharRange(CharUtils.after(to), this.to));
        }
        if (toEnd) {
            return Arrays.asList(new CharRange(this.from, CharUtils.before(from)), new CharRange(from, to));
        }
        return Arrays.asList(new CharRange(this.from, CharUtils.before(from)), new CharRange(from, to), new CharRange(CharUtils.after(to), this.to));
    }

    public int hashCode() {
        return this.from * 7 + this.to * 3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CharRange that = (CharRange)obj;
        return this.from == that.from && this.to == that.to;
    }

    public String toString() {
        return this.from + "-" + this.to;
    }
}

