/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import net.amygdalum.util.text.ByteUtils;

public class ByteString {
    private byte[] bytes;
    private Charset charset;

    public ByteString(byte[] bytes, Charset charset) {
        this.bytes = bytes;
        this.charset = charset;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public Charset charset() {
        return this.charset;
    }

    public String getString() {
        return new String(this.bytes, this.charset);
    }

    public String getMappableSuffix() {
        ByteBuffer buffer = ByteBuffer.wrap(this.bytes);
        while (buffer.hasRemaining()) {
            int pos = buffer.position();
            try {
                return this.charset.newDecoder().decode(buffer).toString();
            }
            catch (CharacterCodingException e) {
                buffer.position(pos + 1);
            }
        }
        return "";
    }

    public String getMappablePrefix() {
        ByteBuffer buffer = ByteBuffer.wrap(this.bytes);
        while (buffer.hasRemaining()) {
            try {
                return this.charset.newDecoder().decode(buffer).toString();
            }
            catch (CharacterCodingException e) {
                buffer.rewind();
                buffer.limit(buffer.limit() - 1);
            }
        }
        return "";
    }

    public boolean isMappable() {
        ByteBuffer buffer = ByteBuffer.wrap(this.bytes);
        if (buffer.hasRemaining()) {
            try {
                this.charset.newDecoder().decode(buffer);
                return true;
            }
            catch (CharacterCodingException e) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(byte[] bytes) {
        return Arrays.equals(this.bytes, bytes);
    }

    public ByteString revert() {
        return new ByteString(ByteUtils.revert(this.bytes), this.charset);
    }
}

