/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.util.Arrays;
import java.util.List;

public class ByteRange {
    private static final int UNKNOWN = -1;
    public int length;
    public byte[] from;
    public byte[] to;
    private int size;

    public ByteRange(byte[] from, byte[] to) {
        this(from, to, -1);
    }

    public ByteRange(byte[] from, byte[] to, int size) {
        this.from = from;
        this.to = to;
        this.length = this.lengthOf(from, to);
        this.size = size;
    }

    public ByteRange(byte from, byte to) {
        this(from, to, -1);
    }

    public ByteRange(byte from, byte to, int size) {
        this.size = size;
        this.from = new byte[]{from};
        this.to = new byte[]{to};
        this.length = 1;
    }

    private int lengthOf(byte[] from, byte[] to) {
        if (from.length != to.length) {
            throw new IllegalArgumentException();
        }
        return from.length;
    }

    public boolean contains(byte ... value) {
        if (value.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            int fromI = this.from[i] & 0xFF;
            int toI = this.to[i] & 0xFF;
            int valueI = value[i] & 0xFF;
            if (fromI > valueI || toI < valueI) {
                return false;
            }
            if (fromI >= valueI || toI <= valueI) continue;
            return true;
        }
        return true;
    }

    public boolean ranges(byte from, byte to) {
        return this.length == 1 && this.from[0] == from && this.to[0] == to;
    }

    public boolean ranges(byte[] from, byte[] to) {
        return this.length == from.length && Arrays.equals(this.from, from) && this.length == to.length && Arrays.equals(this.to, to);
    }

    public int size() {
        return this.size;
    }

    public List<ByteRange> splitBefore(byte ... value) {
        if (this.length != value.length) {
            return Arrays.asList(this);
        }
        if (Arrays.equals(value, this.from)) {
            return Arrays.asList(this);
        }
        return Arrays.asList(new ByteRange(this.from, this.before(value), -1), new ByteRange(value, this.to, -1));
    }

    public List<ByteRange> splitAfter(byte ... value) {
        if (this.length != value.length) {
            return Arrays.asList(this);
        }
        if (Arrays.equals(value, this.to)) {
            return Arrays.asList(this);
        }
        return Arrays.asList(new ByteRange(this.from, value, -1), new ByteRange(this.after(value), this.to, -1));
    }

    public List<ByteRange> splitAround(byte from, byte to) {
        boolean toEnd;
        if (this.length != 1) {
            return Arrays.asList(this);
        }
        boolean fromStart = this.from[0] == from;
        boolean bl = toEnd = this.to[0] == to;
        if (fromStart && toEnd) {
            return Arrays.asList(this);
        }
        if (fromStart) {
            return Arrays.asList(new ByteRange(from, to, -1), new ByteRange(this.after(to), this.to, -1));
        }
        if (toEnd) {
            return Arrays.asList(new ByteRange(this.from, this.before(from), -1), new ByteRange(from, to, -1));
        }
        return Arrays.asList(new ByteRange(this.from, this.before(from), -1), new ByteRange(from, to, -1), new ByteRange(this.after(to), this.to, -1));
    }

    public List<ByteRange> splitAround(byte[] from, byte[] to) {
        if (this.length != from.length || this.length != to.length) {
            return Arrays.asList(this);
        }
        boolean fromStart = Arrays.equals(this.from, from);
        boolean toEnd = Arrays.equals(this.to, to);
        if (fromStart && toEnd) {
            return Arrays.asList(this);
        }
        if (fromStart) {
            return Arrays.asList(new ByteRange(from, to, -1), new ByteRange(this.after(to), this.to, -1));
        }
        if (toEnd) {
            return Arrays.asList(new ByteRange(this.from, this.before(from), -1), new ByteRange(from, to, -1));
        }
        return Arrays.asList(new ByteRange(this.from, this.before(from), -1), new ByteRange(from, to, -1), new ByteRange(this.after(to), this.to, -1));
    }

    private byte[] before(byte ... value) {
        byte[] before = Arrays.copyOf(value, value.length);
        for (int i = before.length - 1; i >= 0; --i) {
            int n = i;
            before[n] = (byte)(before[n] - 1);
            if (before[i] == -1) continue;
            return before;
        }
        return before;
    }

    private byte[] after(byte ... value) {
        byte[] after = Arrays.copyOf(value, value.length);
        for (int i = after.length - 1; i >= 0; --i) {
            int n = i;
            after[n] = (byte)(after[n] + 1);
            if (after[i] == 0) continue;
            return after;
        }
        return after;
    }

    public int hashCode() {
        return Arrays.hashCode(this.from) * 7 + Arrays.hashCode(this.to) * 3 + this.size;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteRange that = (ByteRange)obj;
        return Arrays.equals(this.from, that.from) && Arrays.equals(this.to, that.to) && this.size == that.size;
    }

    public String toString() {
        return Arrays.toString(this.from) + "-" + Arrays.toString(this.to) + ":" + this.size;
    }
}

