/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.amygdalum.util.builders.Lists;
import net.amygdalum.util.builders.Maps;
import net.amygdalum.util.text.ByteRange;

public final class ByteEncoding {
    private static final Map<Charset, List<ByteRange>> partitionings = ByteEncoding.initPartitionings();

    private static Map<Charset, List<ByteRange>> initPartitionings() {
        return Maps.hashed().put(StandardCharsets.UTF_8, Lists.list(new ByteRange[0]).add(new ByteRange(0, 127, 128)).add(new ByteRange(new byte[]{-62, -128}, new byte[]{-33, -65}, 1920)).add(new ByteRange(new byte[]{-32, -96, -128}, new byte[]{-17, -65, -65}, 63488)).build()).build();
    }

    public static List<ByteRange> getPartitioningFor(Charset charset) {
        List<ByteRange> part = partitionings.get(charset);
        if (part == null) {
            part = ByteEncoding.bruteForce(charset);
            partitionings.put(charset, part);
        }
        return part;
    }

    private static List<ByteRange> bruteForce(Charset charset) {
        ArrayList<ByteRange> ranges = new ArrayList<ByteRange>();
        byte[] start = null;
        int size = 0;
        byte[] last = null;
        for (int i = 0; i <= 65535; ++i) {
            byte[] current = ByteEncoding.encode((char)i);
            if (start == null) {
                start = current;
                last = current;
                size = 1;
                continue;
            }
            if (start.length == current.length) {
                last = current;
                ++size;
                continue;
            }
            ranges.add(new ByteRange(start, last, size));
            start = current;
            last = current;
            size = 1;
        }
        return ranges;
    }

    public static byte[] encode(String pattern) {
        return ByteEncoding.encode(pattern, StandardCharsets.UTF_8);
    }

    public static byte[] encode(String pattern, Charset charset) {
        try {
            CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer buffer = encoder.encode(CharBuffer.wrap(pattern));
            byte[] encoded = new byte[buffer.limit()];
            buffer.get(encoded);
            return encoded;
        }
        catch (CharacterCodingException e) {
            return new byte[0];
        }
    }

    public static byte[] encode(char pattern) {
        return ByteEncoding.encode(StandardCharsets.UTF_8, pattern);
    }

    public static byte[] encode(Charset charset, char pattern) {
        try {
            CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer buffer = encoder.encode(CharBuffer.wrap(new char[]{pattern}));
            byte[] encoded = new byte[buffer.limit()];
            buffer.get(encoded);
            return encoded;
        }
        catch (CharacterCodingException e) {
            return new byte[0];
        }
    }

    public static String decode(byte ... pattern) {
        return ByteEncoding.decode(StandardCharsets.UTF_8, pattern);
    }

    public static String decode(Charset charset, byte ... pattern) {
        try {
            CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer buffer = decoder.decode(ByteBuffer.wrap(pattern));
            return buffer.toString();
        }
        catch (CharacterCodingException e) {
            return "";
        }
    }

    public static List<ByteRange> intervals(Charset charset, char from, char to) {
        byte[] bytesFrom = ByteEncoding.encode(charset, from);
        byte[] bytesTo = ByteEncoding.encode(charset, to);
        List<ByteRange> partitioning = ByteEncoding.getPartitioningFor(charset);
        ArrayList<ByteRange> intervals = new ArrayList<ByteRange>(partitioning.size());
        char base = '\u0000';
        for (ByteRange part : partitioning) {
            if (from >= base && from < base + part.size() && to >= base && to < base + part.size()) {
                intervals.add(new ByteRange(bytesFrom, bytesTo, to - from));
            } else if (from >= base && from < base + part.size()) {
                intervals.add(new ByteRange(bytesFrom, part.to, base + part.size() - from));
            } else if (from < base && to >= base + part.size()) {
                intervals.add(part);
            } else if (to >= base && to < base + part.size()) {
                intervals.add(new ByteRange(part.from, bytesTo, to - base));
            }
            base = (char)(base + part.size());
        }
        return intervals;
    }
}

