/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

public abstract class TuneableMap {
    public static final int DEFAULT_SIZE = 16;
    public static final float DEFAULT_LOAD = 0.7f;
    private static final int INT_PHI = -1640531527;
    private static final long LONG_PHI = -7046029254386353131L;

    protected static int mask(int initialSize, float loadFactor) {
        long size = (long)Math.ceil((double)initialSize / (double)loadFactor);
        if (size <= 0L) {
            return 1;
        }
        --size;
        size |= size >> 1;
        size |= size >> 2;
        size |= size >> 4;
        size |= size >> 8;
        size |= size >> 16;
        if ((size |= size >> 32) < 2L) {
            return 1;
        }
        return (int)size;
    }

    public int hash(int key) {
        int h = key * -1640531527;
        return h ^ h >> 16;
    }

    public int hash(long key) {
        long h = key * -7046029254386353131L;
        h ^= h >> 32;
        return (int)(h ^ h >> 16);
    }
}

