/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.amygdalum.util.map.TuneableMap;

public class CharObjectMap<T>
extends TuneableMap {
    private static final char NULL_KEY = '\u0000';
    private float loadFactor;
    private int mask;
    private int expandAt;
    private int size;
    private char[] keys;
    private T[] values;
    private T defaultValue;
    private T nullValue;

    public CharObjectMap(T defaultValue) {
        this(16, 0.7f, defaultValue);
    }

    public CharObjectMap(int initialSize, float loadFactor, T defaultValue) {
        this.loadFactor = loadFactor;
        this.mask = CharObjectMap.mask(initialSize, loadFactor);
        this.expandAt = initialSize;
        this.size = 0;
        this.keys = new char[this.mask + 1];
        this.values = new Object[this.mask + 1];
        this.defaultValue = defaultValue;
        this.nullValue = defaultValue;
    }

    public int size() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        return size;
    }

    public char[] keys() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        char[] keys = new char[size];
        int pos = 0;
        for (char c : this.keys) {
            if (c == '\u0000') continue;
            keys[pos] = c;
            ++pos;
        }
        if (this.nullValue != this.defaultValue) {
            keys[pos] = '\u0000';
        }
        Arrays.sort(keys);
        return keys;
    }

    public CharObjectMap<T> add(char key, T value) {
        this.put(key, value);
        return this;
    }

    public void put(char key, T value) {
        if (key == '\u0000') {
            this.nullValue = value;
            return;
        }
        int slot = this.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            ++this.size;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (this.size > this.expandAt) {
            this.expand(this.size * 2);
        }
    }

    public T get(char key) {
        if (key == '\u0000') {
            return this.nullValue;
        }
        int slot = this.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            return this.defaultValue;
        }
        return this.values[slot];
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Iterable<Entry<T>> cursor() {
        return new EntryIterable(this);
    }

    private void expand(int size) {
        int i;
        int mask = CharObjectMap.mask(size, this.loadFactor);
        char[] oldkeys = this.keys;
        T[] oldvalues = this.values;
        char[] keys = new char[mask + 1];
        Object[] values = new Object[mask + 1];
        int[] delayed = new int[this.size];
        int pos = 0;
        for (i = 0; i < oldkeys.length; ++i) {
            char key = oldkeys[i];
            if (key == '\u0000') continue;
            T value = oldvalues[i];
            int slot = this.hash(key) & mask;
            if (keys[slot] == '\u0000') {
                keys[slot] = key;
                values[slot] = value;
                continue;
            }
            delayed[pos] = i;
            ++pos;
        }
        for (i = 0; i <= pos; ++i) {
            int j = delayed[i];
            char key = oldkeys[j];
            T value = oldvalues[j];
            int slot = this.hash(key) & mask;
            while (keys[slot] != key && keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
        this.expandAt = size;
        this.mask = mask;
        this.keys = keys;
        this.values = values;
    }

    public String toString() {
        Entry<T> entry;
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        Iterator<Entry<T>> cursor = this.cursor().iterator();
        if (cursor.hasNext()) {
            entry = cursor.next();
            buffer.append(entry.toString());
        }
        while (cursor.hasNext()) {
            entry = cursor.next();
            buffer.append(",\n").append(entry.toString());
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    public static class Entry<T> {
        public char key;
        public T value;

        public String toString() {
            String keystr = "'" + this.key + "'";
            return keystr + ':' + this.value;
        }
    }

    public static class EntryIterator<T>
    implements Iterator<Entry<T>> {
        private CharObjectMap<T> map;
        private int index;
        private int currentKey;
        private int fixedSize;
        private Entry<T> entry;

        public EntryIterator(CharObjectMap<T> map) {
            this.map = map;
            this.index = 0;
            this.currentKey = -1;
            this.fixedSize = ((CharObjectMap)map).size;
            this.entry = new Entry();
        }

        @Override
        public boolean hasNext() {
            if (((CharObjectMap)this.map).size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            return this.index < this.fixedSize || this.index == this.fixedSize && ((CharObjectMap)this.map).nullValue != ((CharObjectMap)this.map).defaultValue;
        }

        @Override
        public Entry<T> next() {
            if (((CharObjectMap)this.map).size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            while (this.currentKey < ((CharObjectMap)this.map).keys.length - 1) {
                ++this.currentKey;
                char c = ((CharObjectMap)this.map).keys[this.currentKey];
                if (c == '\u0000') continue;
                this.entry.key = ((CharObjectMap)this.map).keys[this.currentKey];
                this.entry.value = ((CharObjectMap)this.map).values[this.currentKey];
                ++this.index;
                return this.entry;
            }
            if (((CharObjectMap)this.map).nullValue != ((CharObjectMap)this.map).defaultValue) {
                this.entry.key = '\u0000';
                this.entry.value = ((CharObjectMap)this.map).nullValue;
                ++this.index;
                return this.entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentKey < 0) {
                throw new NoSuchElementException();
            }
            if (((CharObjectMap)this.map).keys[this.currentKey] != '\u0000') {
                ((CharObjectMap)this.map).size--;
            } else if (((CharObjectMap)this.map).values[this.currentKey] != ((CharObjectMap)this.map).defaultValue) {
                ((CharObjectMap)this.map).nullValue = ((CharObjectMap)this.map).defaultValue;
            }
            ((CharObjectMap)this.map).keys[this.currentKey] = '\u0000';
            ((CharObjectMap)this.map).values[this.currentKey] = ((CharObjectMap)this.map).defaultValue;
        }
    }

    public static class EntryIterable<T>
    implements Iterable<Entry<T>> {
        private CharObjectMap<T> map;

        public EntryIterable(CharObjectMap<T> map) {
            this.map = map;
        }

        @Override
        public Iterator<Entry<T>> iterator() {
            return new EntryIterator<T>(this.map);
        }
    }
}

