/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.amygdalum.util.map.TuneableMap;

public class CharIntMap
extends TuneableMap {
    private static final char NULL_KEY = '\u0000';
    private float loadFactor;
    private int mask;
    private int expandAt;
    private int size;
    private char[] keys;
    private int[] values;
    private int defaultValue;
    private int nullValue;

    public CharIntMap(int defaultValue) {
        this(16, 0.7f, defaultValue);
    }

    public CharIntMap(int initialSize, float loadFactor, int defaultValue) {
        this.loadFactor = loadFactor;
        this.mask = CharIntMap.mask(initialSize, loadFactor);
        this.expandAt = initialSize;
        this.size = 0;
        this.keys = new char[this.mask + 1];
        this.values = new int[this.mask + 1];
        this.defaultValue = defaultValue;
        this.nullValue = defaultValue;
    }

    public int size() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        return size;
    }

    public char[] keys() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        char[] keys = new char[size];
        int pos = 0;
        for (char c : this.keys) {
            if (c == '\u0000') continue;
            keys[pos] = c;
            ++pos;
        }
        if (this.nullValue != this.defaultValue) {
            keys[pos] = '\u0000';
        }
        return keys;
    }

    public CharIntMap add(char key, int value) {
        this.put(key, value);
        return this;
    }

    public void put(char key, int value) {
        if (key == '\u0000') {
            this.nullValue = value;
            return;
        }
        int slot = this.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            ++this.size;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (this.size > this.expandAt) {
            this.expand(this.size * 2);
        }
    }

    public int get(char key) {
        if (key == '\u0000') {
            return this.nullValue;
        }
        int slot = this.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            return this.defaultValue;
        }
        return this.values[slot];
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public Iterable<Entry> cursor() {
        return new EntryIterable(this);
    }

    private void expand(int size) {
        int i;
        int mask = CharIntMap.mask(size, this.loadFactor);
        char[] oldkeys = this.keys;
        int[] oldvalues = this.values;
        char[] keys = new char[mask + 1];
        int[] values = new int[mask + 1];
        int[] delayed = new int[this.size];
        int pos = 0;
        for (i = 0; i < oldkeys.length; ++i) {
            char key = oldkeys[i];
            if (key == '\u0000') continue;
            int value = oldvalues[i];
            int slot = this.hash(key) & mask;
            if (keys[slot] == '\u0000') {
                keys[slot] = key;
                values[slot] = value;
                continue;
            }
            delayed[pos] = i;
            ++pos;
        }
        for (i = 0; i <= pos; ++i) {
            int j = delayed[i];
            char key = oldkeys[j];
            int value = oldvalues[j];
            int slot = this.hash(key) & mask;
            while (keys[slot] != key && keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
        this.expandAt = size;
        this.mask = mask;
        this.keys = keys;
        this.values = values;
    }

    public String toString() {
        Entry entry;
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        Iterator<Entry> cursor = this.cursor().iterator();
        if (cursor.hasNext()) {
            entry = cursor.next();
            buffer.append(entry.toString());
        }
        while (cursor.hasNext()) {
            entry = cursor.next();
            buffer.append(",\n").append(entry.toString());
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    public static class Entry {
        public char key;
        public long value;

        public String toString() {
            String keystr = "'" + this.key + "'";
            return keystr + ':' + this.value;
        }
    }

    public static class EntryIterator
    implements Iterator<Entry> {
        private CharIntMap map;
        private int index;
        private int currentKey;
        private int fixedSize;
        private Entry entry;

        public EntryIterator(CharIntMap map) {
            this.map = map;
            this.index = 0;
            this.currentKey = -1;
            this.fixedSize = map.size;
            this.entry = new Entry();
        }

        @Override
        public boolean hasNext() {
            if (this.map.size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            return this.index < this.fixedSize || this.index == this.fixedSize && this.map.nullValue != this.map.defaultValue;
        }

        @Override
        public Entry next() {
            if (this.map.size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            while (this.currentKey < this.map.keys.length - 1) {
                ++this.currentKey;
                char c = this.map.keys[this.currentKey];
                if (c == '\u0000') continue;
                this.entry.key = this.map.keys[this.currentKey];
                this.entry.value = this.map.values[this.currentKey];
                ++this.index;
                return this.entry;
            }
            if (this.map.nullValue != this.map.defaultValue) {
                this.entry.key = '\u0000';
                this.entry.value = this.map.nullValue;
                ++this.index;
                return this.entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentKey < 0) {
                throw new NoSuchElementException();
            }
            if (this.map.keys[this.currentKey] != '\u0000') {
                this.map.size--;
            } else if (this.map.values[this.currentKey] != this.map.defaultValue) {
                this.map.nullValue = this.map.defaultValue;
            }
            ((CharIntMap)this.map).keys[this.currentKey] = '\u0000';
            ((CharIntMap)this.map).values[this.currentKey] = this.map.defaultValue;
        }
    }

    public static class EntryIterable
    implements Iterable<Entry> {
        private CharIntMap map;

        public EntryIterable(CharIntMap map) {
            this.map = map;
        }

        @Override
        public Iterator<Entry> iterator() {
            return new EntryIterator(this.map);
        }
    }
}

